DELIMITER $$
DROP PROCEDURE IF EXISTS V20250122145233__Create_dublinDescriptorTable $$
CREATE PROCEDURE V20250122145233__Create_dublinDescriptorTable()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='dublin_descriptors_csm') THEN 
CREATE TABLE `dublin_descriptors_csm` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `programPhaseId` bigint NOT NULL,
  `dublinDescriptorsName` varchar(255) NOT NULL,
  `dublinDescriptorsDescription` varchar(512) DEFAULT NULL,
  `dublinDescriptorsActiveInactiveEnum` varchar(20) NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dublin_descriptors_csm_UNIQUE` (`dublinDescriptorsName`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  KEY `programPhaseId` (`programPhaseId`),
  CONSTRAINT `dublin_descriptors_csm_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `dublin_descriptors_csm_ibfk_2` FOREIGN KEY (`programPhaseId`) REFERENCES `program_phase` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20250122145233__Create_dublinDescriptorTable () $$ 
DROP PROCEDURE IF EXISTS V20250122145233__Create_dublinDescriptorTable $$ 
DELIMITER ;