DELIMITER $$
DROP PROCEDURE IF EXISTS V20250122155327__Create_ProgramLearningOutcome $$
CREATE PROCEDURE V20250122155327__Create_ProgramLearningOutcome()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_learning_outcome_csm') THEN 
CREATE TABLE `program_learning_outcome_csm` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `programId` bigint NOT NULL,
  `programLearningOutcomeName` varchar(255) NOT NULL,
  `programLearningOutcomeDescription` varchar(512) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dprogram_learning_outcome_csm_UNIQUE` (`programLearningOutcomeName`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  KEY `programId` (`programId`),
  CONSTRAINT `program_learning_outcome_csm_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `program_learning_outcome_csm_ibfk_2` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20250122155327__Create_ProgramLearningOutcome () $$ 
DROP PROCEDURE IF EXISTS V20250122155327__Create_ProgramLearningOutcome $$ 
DELIMITER ;