DELIMITER $$

DROP PROCEDURE IF EXISTS V20250122181727__Insert_trans_centeralloc_angularportal $$

CREATE PROCEDURE V20250122181727__Insert_trans_centeralloc_angularportal()
BEGIN

    -- Insert for CENTER_NAME
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='CENTER_NAME') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'CENTER_NAME', 'Center Name', 'Center Name', 'Sentrum naam', 'Tên trung tâm', NOW(), 1);
    END IF;

    -- Insert for TIME_SLOT
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='TIME_SLOT') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'TIME_SLOT', 'Time Slot', 'Time Slot', 'Tydgleuf', 'Khoảng thời gian', NOW(), 1);
    END IF;

    -- Insert for ELECTRONIC_DOCUMENT
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='ELECTRONIC_DOCUMENT') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'ELECTRONIC_DOCUMENT', 'Electronic Document', 'Electronic Document', 'Elektroniese dokument', 'Tài liệu điện tử', NOW(), 1);
    END IF;

    -- Insert for INSPECTION_REQUIRED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='INSPECTION_REQUIRED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'INSPECTION_REQUIRED', 'Inspection Required', 'Inspection Required', 'Inspeksie benodig', 'Kiểm tra bắt buộc', NOW(), 1);
    END IF;

    -- Insert for INSPECTION_DONE_BY
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='INSPECTION_DONE_BY') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'INSPECTION_DONE_BY', 'Inspection Done By', 'Inspection Done By', 'Inspeksie gedoen deur', 'Kiểm tra bởi', NOW(), 1);
    END IF;

    -- Insert for RETURNABLE_DOCUMENT
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='RETURNABLE_DOCUMENT') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'RETURNABLE_DOCUMENT', 'Returnable Document', 'Returnable Document', 'Terugbetaalbare dokument', 'Tài liệu có thể trả lại', NOW(), 1);
    END IF;

    -- Insert for RETURN_BY
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='RETURN_BY') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'RETURN_BY', 'Return By', 'Return By', 'Terug deur', 'Trả bởi', NOW(), 1);
    END IF;

    -- Insert for ASSESSMENT_SCHEME
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='ASSESSMENT_SCHEME') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'ASSESSMENT_SCHEME', 'Assessment Scheme', 'Assessment Scheme', 'Assessering skema', 'Kế hoạch đánh giá', NOW(), 1);
    END IF;

    -- Insert for ASSESSMENT_SCHEME_REQUIRED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='ASSESSMENT_SCHEME_REQUIRED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'ASSESSMENT_SCHEME_REQUIRED', 'Assessment Scheme is required', 'Assessment Scheme is required', 'Assessering skema is nodig', 'Yêu cầu kế hoạch đánh giá', NOW(), 1);
    END IF;

    -- Insert for COURSE
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='COURSE') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'COURSE', 'Course', 'Course', 'Kursus', 'Khóa học', NOW(), 1);
    END IF;

    -- Insert for COURSE_REQUIRED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='COURSE_REQUIRED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'COURSE_REQUIRED', 'Course is required', 'Course is required', 'Kursus is nodig', 'Yêu cầu khóa học', NOW(), 1);
    END IF;

    -- Insert for COURSE_VARIANT_REQUIRED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='COURSE_VARIANT_REQUIRED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'COURSE_VARIANT_REQUIRED', 'Course Variant is required', 'Course Variant is required', 'Kursus variant is nodig', 'Yêu cầu biến thể khóa học', NOW(), 1);
    END IF;

    -- Insert for PERIOD_REQUIRED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='PERIOD_REQUIRED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'PERIOD_REQUIRED', 'Period is required', 'Period is required', 'Tydperk is nodig', 'Yêu cầu thời kỳ', NOW(), 1);
    END IF;

    -- Insert for SECTION_REQUIRED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='SECTION_REQUIRED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'SECTION_REQUIRED', 'Section is required', 'Section is required', 'Afdeling is nodig', 'Yêu cầu phần', NOW(), 1);
    END IF;

    -- Insert for ASSESSMENT_EVENT_REQUIRED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='ASSESSMENT_EVENT_REQUIRED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'ASSESSMENT_EVENT_REQUIRED', 'Assessment Event is required', 'Assessment Event is required', 'Assessering gebeurtenis is nodig', 'Yêu cầu sự kiện đánh giá', NOW(), 1);
    END IF;

    -- Insert for CENTER_ALLOCATION_ADDED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='CENTER_ALLOCATION_ADDED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'CENTER_ALLOCATION_ADDED', 'Center allocation added successfully', 'Center allocation added successfully', 'Sentrum toewysing suksesvol bygevoeg', 'Phân bổ trung tâm đã được thêm thành công', NOW(), 1);
    END IF;

    -- Insert for CENTER_ALLOCATION_DELETED
    IF NOT EXISTS (SELECT * FROM `ui_translation` WHERE objectName='STUDENTRESPONSIVEPORTAL' AND keyName='CENTER_ALLOCATION_DELETED') THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
        VALUES ('STUDENTRESPONSIVEPORTAL', 'CENTER_ALLOCATION_DELETED', 'Center allocation deleted successfully', 'Center allocation deleted successfully', 'Sentrum toewysing suksesvol verwyder', 'Phân bổ trung tâm đã được xóa thành công', NOW(), 1);
    END IF;

END $$

CALL V20250122181727__Insert_trans_centeralloc_angularportal() $$

DROP PROCEDURE IF EXISTS V20250122181727__Insert_trans_centeralloc_angularportal $$

DELIMITER ;
