DELIMITER $$
DROP PROCEDURE IF EXISTS getDetailsForImportD2LGrade $$
CREATE PROCEDURE getDetailsForImportD2LGrade()
BEGIN
select cv.courseVariantCode as courseVarCode, cv.id as courseVarId, a.studentId as userId,
eseq.detailSequenceNumber as eventName, eseq.weightage, eseq.evalInMarksOrGrade,
eseq.minMarks, eseq.maxMarks, eseq.roundingCount,  eseq.roundingMode,
c.courseGradeType,  c.courseMarksGrades,  er.* 
from examination_result er
join eval_seq_detail eseq on er.evaluationDetailSequenceId = eseq.id
join admission a on er.admissionId = a.id and a.activeStatus=true
join course_variants cv on er.courseVariantId = cv.id
join courses c on cv.courseId = c.id
join evaluation_type_course etc on er.courseVariantId = etc.courseVariantId and er.sectionId = etc.sectionId and er.periodId = etc.periodId
join course_variant_event_mapping cvem on cvem.evaluationTypeCourseId = etc.id and eseq.id = cvem.eventId and cvem.eventStatus='CONDUCTED'
where  er.examResultStatus is null and eseq.evalInMarksOrGrade = 'GRADE';
END $$
DELIMITER ;