DELIMITER $$
DROP PROCEDURE IF EXISTS V20250422151446__Create_Financial_Support $$
CREATE PROCEDURE V20250422151446__Create_Financial_Support()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='financial_support')) THEN 
CREATE TABLE `financial_support` (
  `id` BIGINT NOT NULL  AUTO_INCREMENT,
  `studentId` BIGINT NOT NULL, 
  `programId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL,
  `accessAndParticipantFlagId` BIGINT DEFAULT NULL, 
  `financialSupportAmount` double(20,2) DEFAULT NULL,
  `financialSupportTypeId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_financial_support_to_program_idx`(`programId`),
  INDEX `fk_financial_support_to_batch_idx` (`batchId`),
  INDEX `fk_financial_support_to_periodId_idx` (`periodId`),
  INDEX `fk_financial_support_to_accessAndParticipantFlagId_idx` (`accessAndParticipantFlagId`),
  INDEX `fk_financial_support_to_financialSupportTypeId_idx` (`financialSupportTypeId`),
  INDEX `fk_financial_support_to_user_idx` (`lastUpdatedBy`) ,
  INDEX fk_financial_support_to_studentidx (studentId),
CONSTRAINT fk_financial_support_to_studentidx
FOREIGN KEY (studentId)
REFERENCES students (userId)
ON DELETE RESTRICT
ON UPDATE RESTRICT,
  CONSTRAINT `fk_financial_support_to_program_idx` 
	FOREIGN KEY (`programId`) 
	REFERENCES `programs`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_financial_support_to_batch_idx`
	FOREIGN KEY (`batchId`)
	REFERENCES `batches` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
    CONSTRAINT `fk_financial_support_to_periodId_idx`
	FOREIGN KEY (`periodId`)
	REFERENCES `prog_batch_period_config` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
    CONSTRAINT `fk_financial_support_to_accessAndParticipantFlagId_idx`
	FOREIGN KEY (`accessAndParticipantFlagId`)
	REFERENCES `access_and_participation_flag` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
    CONSTRAINT `fk_financial_support_to_financialSupportTypeId_idx`
	FOREIGN KEY (`financialSupportTypeId`)
	REFERENCES `financial_support_type` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_financial_support_to_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 
END $$
CALL V20250422151446__Create_Financial_Support () $$ 
DROP PROCEDURE IF EXISTS V20250422151446__Create_Financial_Support $$ 
DELIMITER ;