DELIMITER $$

DROP PROCEDURE IF EXISTS sp_get_application_program_data $$
CREATE PROCEDURE sp_get_application_program_data(IN in_application_id BIGINT)
BEGIN
    SELECT
        ap.id AS program_id,
        apperson.externalSysRefThree,
        ac.academyName,
        loc.locationName,
        prog.programName,
        iy.itemValue AS intake_year,
        st.seatName,
        pg.groupName AS program_group_name,
        -- Admission Status (from ENUM directly)
        (
    SELECT
        aad.status
    FROM application_admission_detail aad
    WHERE aad.applicationProgramId = ap.id
    LIMIT 1
) AS admission_status_code,
        -- Commitment Fee Status (from ENUM directly)
        (
    SELECT
        bh.billStatus
    FROM bill_header bh
    JOIN fee_stage_master fsm ON bh.feeStageMasterId = fsm.id
    WHERE bh.applicantId = app.id
      AND LOWER(fsm.stageName) = 'admission commitment'
    LIMIT 1
) AS commitment_fee_status,

        ap.currentStatus AS offer_status,

        ap.whetherHostelApplicable AS boarding_required

    FROM application app
    LEFT JOIN application_program ap ON ap.applicationId = app.id
    LEFT JOIN applicant_person apperson ON app.applicantPersonId = apperson.id
    LEFT JOIN academy_location al ON ap.academyLocationId = al.id
    LEFT JOIN academies ac ON al.academyId = ac.id
    LEFT JOIN locations loc ON al.locationId = loc.id
    LEFT JOIN programs prog ON ap.programId = prog.id
    LEFT JOIN prog_batch_seat_config pbsc ON ap.progBatchSeatConfigId = pbsc.id
    LEFT JOIN seat_types st ON pbsc.seatTypeId = st.id
    LEFT JOIN batches b ON pbsc.programBatchId = b.id
    LEFT JOIN intake_year iy ON b.intakeYearId = iy.id
    LEFT JOIN program_group pg ON app.programGroupId = pg.id
    WHERE app.id = in_application_id;
END$$

DELIMITER ;
