DELIMITER $$
DROP PROCEDURE IF EXISTS V20250512185722__Create_GrayQuest_Payment_Child $$
CREATE PROCEDURE V20250512185722__Create_GrayQuest_Payment_Child()
BEGIN
SET SQL_SAFE_UPDATES = 0;
    IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'gray_quest_payment_gateway') THEN
        CREATE TABLE `gray_quest_payment_gateway` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `academyLocationId` BIGINT(20) NOT NULL,
			`clientId` VARCHAR(1000),
			`clientSecret` VARCHAR(1000),
            `apiKey` VARCHAR(1000),
			`slug` VARCHAR(1000),
            `environment` VARCHAR(1000),
            `fetchEmiURl` VARCHAR(1000),
            `productionURL` VARCHAR(1000),
            `customCol1` VARCHAR(1000),
            `customCol2` VARCHAR(1000),
            `customCol3` VARCHAR(1000),
           `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `lastUpdatedBy` BIGINT(20) NOT NULL,
            PRIMARY KEY (`id`),
            INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
            INDEX `fk_grayQuest_payment_gateway_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_grayQuest_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_grayQuest_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT
        );
    END IF;
    IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'gray_quest_payment_gateway' LIMIT 1) THEN
        SET @standardMasterMaxId = (SELECT COALESCE(MAX(id)) FROM standard_master);
        INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
        VALUES (@standardMasterMaxId + 1, 'gray_quest_payment_gateway', 'GrayQuest', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
    END IF;
    SET @standardMasterId = (SELECT id FROM standard_master WHERE `tableName` = 'gray_quest_payment_gateway' order by  id desc limit 1);
    IF @standardMasterId IS NOT NULL THEN
        UPDATE `standard_master` SET `childMaster` = @standardMasterId, `whetherParent` = 1 WHERE `tableName` = 'standard_payment_gateway';
        IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'GrayQuest') THEN
            INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)
            VALUES (@standardMasterId, 'GrayQuest', false, NOW(), 1);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'clientId' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('clientId', 'CLIENT_ID', @standardMasterId, 'Varchar', 2, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'clientSecret' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('clientSecret', 'CLIENT_SECRET', @standardMasterId, 'Varchar', 3, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'apiKey' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('apiKey', 'API_KEY', @standardMasterId, 'Varchar', 4, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'slug' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('slug', 'SLUG', @standardMasterId, 'Varchar', 5, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'environment' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('environment', 'ENVIRONMENT', @standardMasterId, 'Varchar', 6, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'fetchEmiURl' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('fetchEmiURl', 'FETCHEMIURL', @standardMasterId, 'Varchar', 7, 0, 0, 0, 1, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'productionURL' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('productionURL', 'PRODUCTIONURL', @standardMasterId, 'Varchar', 8, 0, 0, 0, 1, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customCol1' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('customCol1', 'CUSTOMCOL1', @standardMasterId, 'Varchar', 9, 0, 0 ,0 , 1, 1, SYSDATE(),1000);
        END IF;
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customCol2' AND standardMasterId = @standardMasterId) THEN
                    INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
                    VALUES ('customCol2', 'CUSTOMCOL2', @standardMasterId, 'Varchar', 10, 0, 0, 0, 1, 1, SYSDATE(),1000);
        END IF;
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customCol3' AND standardMasterId = @standardMasterId) THEN
                    INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
                    VALUES ('customCol3', 'CUSTOMCOL3', @standardMasterId, 'Varchar', 11, 0, 0, 0, 1, 1, SYSDATE(),1000);
        END IF;
    END IF;
    SET SQL_SAFE_UPDATES = 1;
END $$
CALL V20250512185722__Create_GrayQuest_Payment_Child () $$ 
DROP PROCEDURE IF EXISTS V20250512185722__Create_GrayQuest_Payment_Child $$ 
DELIMITER ;