DELIMITER $$
DROP PROCEDURE IF EXISTS V20250513145216__Insert_CommitteeMembershipLoader $$
CREATE PROCEDURE V20250513145216__Insert_CommitteeMembershipLoader()
BEGIN

IF NOT EXISTS ((select * from import_utility_master where import_utility_master.screenName='Bulk Upload Membership' and code='committeeMembership')) THEN 
 INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`,`lastUpdatedBy`)
 VALUES ('Bulk Upload Membership', 'setup/committeeMembership', 'committeeMembership', '1');
END IF; 

SET @importutilitymasterId=(select id from import_utility_master where code = 'committeeMembership');
-- For college records where isSchool = 0 (false)

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'COMMITTEE_CODE_NAME_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('COMMITTEE_CODE_NAME_HEADER', 'Committee Code/Name', 0, sysdate(), 1, 'Committee Code/Name', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'MEMBERSHIP_TYPE_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('MEMBERSHIP_TYPE_HEADER', 'Membership Type', 0, sysdate(), 1, 'Membership Type', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'VALIDATE_FROM_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('VALIDATE_FROM_HEADER', 'Valid From', 0, sysdate(), 1, 'Valid From', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'VALIDATE_TILL_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('VALIDATE_TILL_HEADER', 'Valid Till', 0, sysdate(), 1, 'Valid Till', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ONLINE_APPLICATION_REQUIRED_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('ONLINE_APPLICATION_REQUIRED_HEADER', 'Online application required', 0, sysdate(), 1, 'Online application required', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'APPLICATION_START_DATE_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('APPLICATION_START_DATE_HEADER', 'Application start date (To be filled mandatory if Online application required is Yes)', 0, sysdate(), 1, 'Application start date (To be filled mandatory if Online application required is Yes)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'APPLICATION_END_DATE_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('APPLICATION_END_DATE_HEADER', 'Application end date (To be filled mandatory if Online application required is Yes)', 0, sysdate(), 1, 'Application end date (To be filled mandatory if Online application required is Yes)', 0, 0, 1, @importutilitymasterId);
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FEE_APPLICABLE_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('FEE_APPLICABLE_HEADER', 'Fee Applicable', 0, sysdate(), 1, 'Fee Applicable', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FEE_PLAN_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('FEE_PLAN_HEADER', 'Fee plan(To be filled mandatory if fee applicable is Yes)', 0, sysdate(), 1, 'Fee plan(To be filled mandatory if fee applicable is Yes)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FEE_RULE_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('FEE_RULE_HEADER', 'Fee rule (To be filled mandatory if fee applicable is Yes)', 0, sysdate(), 1, 'Fee rule (To be filled mandatory if fee applicable is Yes)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'AUTO_APPROVE_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('AUTO_APPROVE_HEADER', 'Auto Apporve', 0, sysdate(), 1, 'Auto Apporve', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'APPROVER_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('APPROVER_HEADER', 'Approver (To be filled mandatory if Auto approve is No)', 0, sysdate(), 1, 'Approver (To be filled mandatory if Auto approve is No)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ADDITIONAL_MEMBERSHIP_HEADER' AND isSchool = false AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('ADDITIONAL_MEMBERSHIP_HEADER', 'Additional Membership', 0, sysdate(), 1, 'Additional Membership', 0, 0, 1, @importutilitymasterId);
END IF; 

-- For School records where isSchool = 0 (false)

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'COMMITTEE_CODE_NAME_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('COMMITTEE_CODE_NAME_HEADER', 'Committee Code/Name', 1, sysdate(), 1, 'Committee Code/Name', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'MEMBERSHIP_TYPE_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('MEMBERSHIP_TYPE_HEADER', 'Membership type', 1, sysdate(), 1, 'Membership type', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'VALIDATE_FROM_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('VALIDATE_FROM_HEADER', 'Valid From', 1, sysdate(), 1, 'Valid From', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'VALIDATE_TILL_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('VALIDATE_TILL_HEADER', 'Valid Till', 1, sysdate(), 1, 'Valid Till', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ONLINE_APPLICATION_REQUIRED_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('ONLINE_APPLICATION_REQUIRED_HEADER', 'Online application required', 1, sysdate(), 1, 'Online application required', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'APPLICATION_START_DATE_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('APPLICATION_START_DATE_HEADER', 'Application start date (To be filled mandatory if Online application required is Yes)', 1, sysdate(), 1, 'Application start date (To be filled mandatory if Online application required is Yes)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'APPLICATION_END_DATE_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('APPLICATION_END_DATE_HEADER', 'Application end date (To be filled mandatory if Online application required is Yes)', 1, sysdate(), 1, 'Application end date (To be filled mandatory if Online application required is Yes)', 0, 0, 1, @importutilitymasterId);
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FEE_APPLICABLE_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('FEE_APPLICABLE_HEADER', 'Fee Applicable', 1, sysdate(), 1, 'Fee Applicable', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FEE_PLAN_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('FEE_PLAN_HEADER', 'Fee plan(To be filled mandatory if fee applicable is Yes)', 1, sysdate(), 1, 'Fee plan(To be filled mandatory if fee applicable is Yes)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FEE_RULE_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('FEE_RULE_HEADER', 'Fee rule (To be filled mandatory if fee applicable is Yes)', 1, sysdate(), 1, 'Fee rule (To be filled mandatory if fee applicable is Yes)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'AUTO_APPROVE_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('AUTO_APPROVE_HEADER', 'Auto Apporve', 1, sysdate(), 1, 'Auto Apporve', 1, 1, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'APPROVER_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('APPROVER_HEADER', 'Approver (To be filled mandatory if Auto approve is No)', 1, sysdate(), 1, 'Approver (To be filled mandatory if Auto approve is No)', 0, 0, 1, @importutilitymasterId);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ADDITIONAL_MEMBERSHIP_HEADER' AND isSchool = true AND importUtilityMasterId = @importutilitymasterId)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`, `isNonEditable`, `isMandatory`, `isVisible`, `importUtilityMasterId`)
	VALUES ('ADDITIONAL_MEMBERSHIP_HEADER', 'Additional Membership', 1, sysdate(), 1, 'Additional Membership', 0, 0, 1, @importutilitymasterId);
END IF; 




END $$
CALL V20250513145216__Insert_CommitteeMembershipLoader() $$
DROP PROCEDURE IF EXISTS V20250513145216__Insert_CommitteeMembershipLoader $$
DELIMITER ;