DELIMITER $$
DROP PROCEDURE IF EXISTS V20250513165129__Alter_IdTypeCSM $$
CREATE PROCEDURE V20250513165129__Alter_IdTypeCSM()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='identity_type') THEN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'identity_type' AND COLUMN_NAME = 'isMaskingNeeded')) THEN 
ALTER TABLE `identity_type` 
ADD COLUMN `isMaskingNeeded` BIT(1) DEFAULT 0;
END IF; 
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'identity_type' AND COLUMN_NAME = 'maskingPattern')) THEN 
ALTER TABLE `identity_type`
ADD COLUMN `maskingPattern` varchar(30) DEFAULT NULL;
END IF; 

END IF;

IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'identity_type')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'identity_type');
INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('isMaskingNeeded','IS_MASKING_NEEDED',@standardMasterId,'Boolean',NULL,3,0,NULL,NULL,NULL,0,0,0,1,now());

INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('maskingPattern','MASKING_PATTERN',@standardMasterId,'Varchar',NULL,4,0,NULL,NULL,NULL,0,0,1,1,now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName = 'IS_MASKING_NEEDED')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'IS_MASKING_NEEDED', 'Is Masking Needed?', 'Is Masking Needed?', 'Is maskering nodig?','Có cần phải che mặt không?',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName = 'MASKING_PATTERN')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'MASKING_PATTERN', 'Masking Pattern', 'Masking Pattern', 'Maskerpatroon','Mẫu mặt nạ',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName = 'ARE_YOU_SURE_YOU_WANT_TO_MASK_ID')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'ARE_YOU_SURE_YOU_WANT_TO_MASK_ID', 'Are you sure you want to mask the ID Number? After saving, the ID cannot be unmasked.', 'Are you sure you want to mask the ID Number? After saving, the ID cannot be unmasked.',
'Is jy seker jy wil die ID-nommer masker? Na gestoor kan die ID nie ontmasker word nie.','Bạn có chắc chắn muốn che số ID không? Sau khi lưu, ID không thể bị lộ.',now(),1);
END IF;

END $$
CALL V20250513165129__Alter_IdTypeCSM() $$
DROP PROCEDURE IF EXISTS V20250513165129__Alter_IdTypeCSM $$
DELIMITER ;