DELIMITER $$
DROP PROCEDURE IF EXISTS V20250513185022__Create_Student_Engagement_Details $$
CREATE PROCEDURE V20250513185022__Create_Student_Engagement_Details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_engagement_detail')) THEN 
CREATE TABLE student_engagement_detail (
id bigint(20) NOT NULL AUTO_INCREMENT,
studentId BIGINT NOT NULL, 
researchCouncilStudentIdentifier VARCHAR(255) DEFAULT NULL,
ukriStudentshipReferenceNumber VARCHAR(255) DEFAULT NULL,
studyIntentionId bigint(20) DEFAULT NULL, 
feeEligibilityId bigint(20) DEFAULT NULL,
incomingExchangeId bigint(20) DEFAULT NULL,
nhsEmployerId bigint(20) DEFAULT NULL,
qualifiedTeacherStatusId bigint(20) DEFAULT NULL,
ittEntryRouteId bigint(20) DEFAULT NULL,
researchCouncilStudentId bigint(20) DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (id),
 INDEX fk_student_engagement_detail_to_studentidx (studentId),
CONSTRAINT fk_student_engagement_detail_to_studentidx FOREIGN KEY (studentId) REFERENCES students (userId),
CONSTRAINT `FK_student_engagement_detail_FK_studyIntentionId` FOREIGN KEY (`studyIntentionId`) REFERENCES `study_intention` (`id`),
CONSTRAINT `FK_student_engagement_detail_FK_feeEligibilityId` FOREIGN KEY (`feeEligibilityId`) REFERENCES `fee_eligibility` (`id`),
CONSTRAINT `FK_student_engagement_detail_FK_incomingExchangeId` FOREIGN KEY (`incomingExchangeId`) REFERENCES `incoming_exchange` (`id`),
CONSTRAINT `FK_student_engagement_detail_FK_nhsEmployerId` FOREIGN KEY (`nhsEmployerId`) REFERENCES `nhs_employer` (`id`),
CONSTRAINT `FK_student_engagement_detail_FK_qualifiedTeacherStatusId` FOREIGN KEY (`qualifiedTeacherStatusId`) REFERENCES `qualified_teacher_status` (`id`),
CONSTRAINT `FK_student_engagement_detail_FK_ittEntryRouteId` FOREIGN KEY (`ittEntryRouteId`) REFERENCES `itt_entry_route` (`id`),
CONSTRAINT `FK_student_engagement_detail_FK_researchCouncilStudentId` FOREIGN KEY (`researchCouncilStudentId`) REFERENCES `research_council_student` (`id`),
CONSTRAINT `FK_student_engagement_detail_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF;
END $$
CALL V20250513185022__Create_Student_Engagement_Details () $$ 
DROP PROCEDURE IF EXISTS V20250513185022__Create_Student_Engagement_Details $$ 
DELIMITER ;