DELIMITER $$
DROP PROCEDURE IF EXISTS sageInvoices $$
CREATE PROCEDURE sageInvoices(
    IN lastUpdate DATETIME, 
    IN invoiceType TEXT, 
    IN invoiceStatus TEXT,
    IN docType TEXT
)
BEGIN
    IF docType = 'NOT_CANCEL_INVOICE_CREDITNOTE' THEN
        SELECT 
            'NUMERO_FACTURE' AS billNo, 
            'DATE_FACTURE' AS billingDate, 
            'MATRICULE_ETUDIANT' AS studentId, 
            'PRENOM' AS firstName, 
            'NOM' AS lastName, 
            'FILIERE' AS programName, 
            'SEMESTRE_CONCERNE' AS period, 
            'LIBELLE_FACTURE' AS feeHeads, 
            'MONTANT' AS invoiceAmount,
			'STATUT' as cancelStatus,
			'RAISON DE L''ANNULATION' as cancelNarration
        UNION ALL
    SELECT DISTINCT
            bill.billNo AS billNo, 
            bill.billingDate AS billingDate, 
            u.code AS studentId, 
            u.firstName AS firstName, 
            u.lastName AS lastName, 
            p.programName AS programName, 
            period.programPeriodName AS period, 
            GROUP_CONCAT(feehead.feeHeadName) AS feeHeads, 
            bill.totalAmount AS invoiceAmount,
			'' as cancelStatus,
			bill.cancellationNarration as cancelNarration
        FROM bill_header bill
		inner join billed_user_type utype on bill.raiseBillFor = utype.id and upper(utype.billedUserType)='STUDENT'
        INNER JOIN bill_fee_plan_rule_stage billstage ON bill.id = billstage.billId
        INNER JOIN fee_stage_head_config feestage ON billstage.feeStageHeadConfigId = feestage.id
        INNER JOIN fee_heads feehead ON feestage.feeHeadId = feehead.id
        INNER JOIN users u ON bill.studentId = u.id
        left JOIN prog_batch_period_config period ON bill.programBatchPeriodConfigId = period.id
        left JOIN batches b ON period.programBatchId = b.id
        left JOIN programs p ON b.programId = p.id
		left join academic_term caterm on caterm.whetherCurrentAcademicTerm = true
		left join academic_term faterm on period.academicTermId = faterm.id and faterm.sequence >=  caterm.sequence
        WHERE 
            bill.raiseBillCategory = invoiceType 
            AND bill.creationDateTime > lastUpdate
            AND bill.billStatus != invoiceStatus 
        GROUP BY bill.id;
    ELSE
        SELECT 
            'NUMERO_FACTURE' AS billNo, 
            'DATE_FACTURE' AS billingDate, 
            'MATRICULE_ETUDIANT' AS studentId, 
            'PRENOM' AS firstName, 
            'NOM' AS lastName, 
            'FILIERE' AS programName, 
            'SEMESTRE_CONCERNE' AS period, 
            'LIBELLE_FACTURE' AS feeHeads, 
            'MONTANT' AS invoiceAmount,
			'STATUT' as cancelStatus,
			'RAISON DE L''ANNULATION' as cancelNarration
        UNION ALL
    SELECT DISTINCT
            bill.billNo AS billNo, 
            bill.billingDate AS billingDate, 
            u.code AS studentId, 
            u.firstName AS firstName, 
            u.lastName AS lastName, 
            p.programName AS programName, 
            period.programPeriodName AS period, 
            GROUP_CONCAT(feehead.feeHeadName) AS feeHeads, 
            bill.totalAmount AS invoiceAmount,
			'' as cancelStatus,
			bill.cancellationNarration as cancelNarration
        FROM bill_header bill
		inner join billed_user_type utype on bill.raiseBillFor = utype.id and upper(utype.billedUserType)='STUDENT'
        INNER JOIN bill_fee_plan_rule_stage billstage ON bill.id = billstage.billId
        INNER JOIN fee_stage_head_config feestage ON billstage.feeStageHeadConfigId = feestage.id
        INNER JOIN fee_heads feehead ON feestage.feeHeadId = feehead.id
        INNER JOIN users u ON bill.studentId = u.id
        left JOIN prog_batch_period_config period ON bill.programBatchPeriodConfigId = period.id
        left JOIN batches b ON period.programBatchId = b.id
        left JOIN programs p ON b.programId = p.id
		left join academic_term caterm on caterm.whetherCurrentAcademicTerm = true
		left join academic_term faterm on period.academicTermId = faterm.id and faterm.sequence >=  caterm.sequence
        WHERE 
            bill.raiseBillCategory = invoiceType 
            AND bill.cancellationDate > lastUpdate
            AND bill.billStatus = invoiceStatus 
        GROUP BY bill.id;
    END IF;
END $$
DELIMITER ;