DELIMITER $$
DROP PROCEDURE IF EXISTS V20250618142835__Alter_AddAcademyLocFacultyCourseInterest $$
CREATE PROCEDURE V20250618142835__Alter_AddAcademyLocFacultyCourseInterest()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'faculty_course_interest' 
      AND COLUMN_NAME = 'academyLocationId'
) THEN
    ALTER TABLE faculty_course_interest
    ADD COLUMN academyLocationId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'faculty_course_interest' 
      AND CONSTRAINT_NAME = 'fk_academy_location'
) THEN
    ALTER TABLE faculty_course_interest
    ADD CONSTRAINT fk_academy_location FOREIGN KEY (academyLocationId) REFERENCES academy_location(id);
END IF; 


END $$
CALL V20250618142835__Alter_AddAcademyLocFacultyCourseInterest() $$
DROP PROCEDURE IF EXISTS V20250618142835__Alter_AddAcademyLocFacultyCourseInterest $$
DELIMITER ;