DELIMITER $$
DROP PROCEDURE IF EXISTS V20250623181241__Insert_Event_DaysForSendOfferLetter_Hostel $$
CREATE PROCEDURE V20250623181241__Insert_Event_DaysForSendOfferLetter_Hostel()
BEGIN

IF NOT EXISTS ((SELECT id FROM msg_category WHERE `code`='HOSTEL')) THEN 
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`, `code`) VALUES (@msgcategoryId+1, 'HOSTEL');
END IF; 

IF NOT EXISTS ((SELECT id FROM msg_category WHERE `code`='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER')) THEN 
	SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='HOSTEL');
	SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
	INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER');

	SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
	SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER');
	
    INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
	VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER', 'Applicant - Days for sending offer letter', 'SYSTEM_SCHEDULE', 0, 0,1, 0, 1, 0, 0, 'Applicant - Days for sending offer letter');

	SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
	INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
	
    SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
	SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
	INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

	SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
	SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
	INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

	SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
	SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
	INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

	SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
	SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
	INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
	
    SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
	INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DAYS_FOR_SENDING_OFFER_LETTER_DL', 'SQL');

	SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
	INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS', 'SQL');

	SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
	SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');
	INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');

	SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
	SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_DL');
	SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');
	INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

	SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
	SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_DL');
	INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id AS USER_ID
	FROM application T1 
	LEFT OUTER JOIN
	applicant_person T2  ON T1.applicantPersonId=T2.id 
	LEFT OUTER JOIN
	applicant_hostel_requirement T3 ON T2.id=T3.applicantPersonId 
    LEFT OUTER JOIN
	applicant_hostel_details T4 ON T3.id=T4.applicantHostelRequirementId 
    LEFT OUTER JOIN
	hostel_application_setup T5  ON T3.waitingListTypeSetupId=T5.id 
    LEFT OUTER JOIN hostel_offer_detail T6 ON T3.id=T6.applicantHostelRequirementId 
	WHERE T3.whetherDeleted=false 
	AND T3.applicationStatus ='OFFER_LETTER_ISSUED'  AND T5.daysSendingOfferLetter IS NOT NULL
	AND T3.convertToStudent= false AND CURDATE() 
	BETWEEN  DATE_ADD(T6.offerLetterIssueDate, INTERVAL (T5.maxDaysToAcceptOffer - T5.daysSendingOfferLetter -1) DAY)
	AND DATE_ADD(T6.offerLetterIssueDate, INTERVAL (T5.maxDaysToAcceptOffer - 1) DAY);",NULL);

	SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
	SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');
	INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
	VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id AS ID,  T2.emailId AS EMAIL_ID, T2.printName AS USERNAME,
	T1.code  AS APPLICATION_ID , T2.printName AS PRINT_NAME,
	T3.itemValue AS ACADEMIC_TERM, T4.daysSendingOfferLetter AS  DAYS_FOR_SENDING_OFFER_LETTER
	FROM  application T1 
    LEFT OUTER JOIN
	applicant_person T2  ON T1.applicantPersonId=T2.id 
    LEFT OUTER JOIN
	applicant_hostel_requirement T6 ON T2.id=T6.applicantPersonId 
    LEFT OUTER JOIN
	applicant_hostel_details T7 ON T6.id=T7.applicantHostelRequirementId 
    LEFT OUTER JOIN
	hostel_application_setup T4 ON T6.waitingListTypeSetupId=T4.id  
    LEFT OUTER JOIN
	academic_term T3  ON T4.year=T3.id 
    LEFT OUTER JOIN
	hostel_offer_detail T5 ON T6.id=T5.applicantHostelRequirementId 
    WHERE T6.applicationStatus ='OFFER_LETTER_ISSUED'  AND  T1.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
		  {
            "id": 3,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "daysSendingOfferLetter",
            "resultKey": "DAYS_FOR_SENDING_OFFER_LETTER",
            "displayCode": "",
            "displayOrder": 3
        }
  	  ]
	}');

	SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
	SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_DL');
	SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
	INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T2.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

	SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
	SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER');

	SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
	SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER');
	SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');
	SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');

	INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
	VALUES(@msgtemplateconfigId+1,'Days for sending offer letter',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'Days for sending offer letter',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

	INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
	VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Days for sending offer letter','<html>
		<head>
			<title></title>
		</head>
		<body>
		<p align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
		 Your Hostel Offer letter is about to expire.
		 Please Accept it.
		 If Already Accepted then ignore this message.
		</p></body>
		</html>');

	INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
	VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Days for sending offer letter','<html>
		<head>
			<title></title>
		</head>
		<body>
		<p align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
		 Your Hostel Offer letter is about to expire.
		 Please Accept it.
		 If Already Accepted then ignore this message.
		</p>
		</body>
		</html>');

SET sql_safe_updates=0;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
update msg_template_config set templateLanguageValue ='English' where templateLanguageValue is null;   
SET sql_safe_updates=1;
   
END IF; 
 
END $$
CALL V20250623181241__Insert_Event_DaysForSendOfferLetter_Hostel() $$
DROP PROCEDURE IF EXISTS V20250623181241__Insert_Event_DaysForSendOfferLetter_Hostel $$
DELIMITER ;