DELIMITER $$
DROP PROCEDURE IF EXISTS getHESAStudentPhaseOne $$
CREATE PROCEDURE getHESAStudentPhaseOne(IN programId BIGINT, IN academicTermId BIGINT)
BEGIN

    SELECT DISTINCT
        adm.code AS ADMISSIONCODE,
        prn.birthDate AS BIRTHDTE,
ethnic.itemCode AS ETHNIC,
prn.firstName AS FNAMES,
genderIdentity.itemCode AS GENDERID,
nation.itemCode AS NATION,
prn.externalSysRefOne AS OWNSTU,
religion.itemCode AS RELIGION,
prn.externalSysRefTwo AS SCN,
gr.itemCode AS SEXID,
sexual.itemCode AS SEXORT,
us.code AS SID,
prn.lastNameOtherLanguage AS SNAME16,
prn.academicBankCredits AS SSN,
prn.lastName AS SURNAME,
termTypeAcc.itemCode AS TTACCOM,
prn.postNumber AS TTPCODE,
prn.coaStudent AS UCASPERID,
prn.naadStudent AS ULN,
ddd.name AS DISABILITY,
#####################################
adm.code AS NUMHUS,
multiLang.code AS EMPLOYINGSCHOOL,
# AS ENGEXPECTEDENDDATE,
sadc.name AS ENGPRINONUK,
adm.admissionDate AS ENGSTARTDATE,
ittEntry.itemCode AS ENTRYRTE,
feeEligibility.itemCode AS FEEELIG,
incomeExchange.itemCode AS INCOMINGEXCHANGE,
contactLang.code AS LEADSCHOOL,
nhsEmployer.itemCode AS NHSEMP,
prn.leadOwner AS OWNENGID,
qualifiedTStatus.itemCode AS QTS,
studentEngagement.researchCouncilStudentIdentifier AS RCSTDID,
researchCouncilS.itemCode AS RCSTDNT,
studyIntention.itemCode AS STUDYINTENTION,
studentEngagement.ukriStudentshipReferenceNumber AS UKRISRN,
#####################################
stuJointDegree.collaborationAgreementType AS COLPROVTYPEID,
stuJointDegree.partnerSid AS PARTNERSID,
stuJointDegree.partnerUkprn AS PARTNERUKPRN,
#####################################
# AS CRDPTSTU,
parentAnnualIncome.name AS SEC,
schoolFeePerYears.name AS SOC2010,
isScholarship.name AS SOC2020,
#####################################
#adm. AS ENGENDDATE,
adm.inactiveReasonCode AS RSNENGEND,
#####################################
pcd.awardCertificate AS QUALAWARDID,
ps.programCode AS QUALID,
pccsm.itemCode AS QUALAWARDRESULT,
#####################################
curr.itemCode AS QUALAWARDACCID,
#####################################
cacc.itemCode AS STUACCID,
#####################################
equivalent.itemCode AS ELQ,
fundingComp.itemCode AS FUNDCOMP,
fundingLeng.itemCode AS FUNDLENGTH,
nonReg.itemCode AS NONREGFEE, 
#####################################
adt.itemCode AS ACTDURATIONTYPE,
       campus.startDate AS ACTSTARTDATE,
       campus.endDate AS  ACTENDDATE,
       ati.itemCode AS ACTTYPEID,
       cc.countryName AS COUNTRY,
       hosti.itemCode AS HOSTID,
       hit.itemCode AS HOSTIDTYPE,
       mobSch.itemCode AS MOBSCHEME,
       campus.moduleInstanceIdentifier AS MODINSTID,
       campus.campusCode AS OVAID,
#####################################
'01' AS REFPERIOD,
pbpc.programPeriodSeq AS RPSTULOAD,
py.itemCode AS YEAR,
#####################################
al.academyCode AS STUDYLOCID,
CASE 
            WHEN ps.isLongDistanceProgram = 1 AND al.locationName = 'UK' THEN 1
            WHEN ps.isLongDistanceProgram = 1 AND (al.locationName <> 'UK' OR al.locationName IS NULL) THEN 2
            ELSE NULL
        END AS DISTANCE,
'100' AS STUDYPROPORTION,
al.academyCode AS VENUEID
#####################################
 

    FROM admission adm
    JOIN program_batch_students pbs ON pbs.admissionId = adm.id AND pbs.isCurrentPeriod = 1 AND pbs.isCurrentSection = 1 AND pbs.exitDate IS NULL

    LEFT JOIN students stu ON adm.studentId = stu.userId
    left join student_engagement_detail studentEngagement on studentEngagement.studentId=stu.userId
    left join itt_entry_route ittEntry on ittEntry.id=studentEngagement.ittEntryRouteId
    left join fee_eligibility feeEligibility on feeEligibility.id=studentEngagement.feeEligibilityId
    left join incoming_exchange incomeExchange on incomeExchange.id=studentEngagement.incomingExchangeId
    left join nhs_employer nhsEmployer on nhsEmployer.id=studentEngagement.nhsEmployerId
    left join qualified_teacher_status qualifiedTStatus on qualifiedTStatus.id=studentEngagement.qualifiedTeacherStatusId
    left join research_council_student researchCouncilS on researchCouncilS.id=studentEngagement.researchCouncilStudentId
    left join study_intention studyIntention on studyIntention.id=studentEngagement.studyIntentionId
    
    LEFT JOIN persons prn ON prn.id = stu.personId
    left join ethnicity_csm ethnic on ethnic.id=prn.ethnicityCSMId
    left join gender_identity_csm genderIdentity on genderIdentity.id=prn.genderIdentityCSMId
    left join nationalities nation on nation.id=prn.nationalityId
    left join religions religion on religion.id=religionId
    left join sexual_orientation_csm sexual on sexual.id=prn.sexualOrientationCSMId
    left join term_time_accomodation_type_csm termTypeAcc on termTypeAcc.id = prn.tertTimeAccomodationTypeCSMId
    left join multi_language multiLang on multiLang.id=prn.correspondence_language
    left join multi_language contactLang on contactLang.id=prn.contact_language
    left join drop_down sadc on sadc.id=prn.sadcCitizenship
	LEFT JOIN users us ON us.id = stu.userId
    LEFT JOIN prog_batch_period_config pbpc ON pbpc.id = pbs.progBatchPeriodConfigId
    LEFT JOIN batches btc ON pbs.programBatchId = btc.id
    LEFT JOIN programs ps ON ps.id = btc.programId
    left join curriculum_accrediation_mapping currMapping on currMapping.programId=ps.id
    left join curriculum_accrediation curr on curr.id=currMapping.curriculumAccrediationId
    LEFT JOIN gender gr ON prn.genderId = gr.id
    LEFT JOIN person_disability pd ON pd.personId = prn.id
    LEFT JOIN drop_down ddd ON ddd.id = pd.haveDisabilityId
    LEFT JOIN period_year py ON py.id = pbpc.periodYearId
    
    LEFT JOIN program_completion_details pcd ON pcd.admissionId = adm.id
    LEFT JOIN program_completion_award_type_csm pccsm ON pccsm.id = pcd.awardTypeId
    LEFT JOIN curriculum_accrediation_mapping cam ON cam.programId = ps.id
    LEFT JOIN curriculum_accrediation cacc ON cacc.id = cam.curriculumAccrediationId
    left join funding_and_monitoring fundingMon on fundingMon.programId=ps.id
    left join equivalent_or_lower_qualification equivalent on equivalent.id=fundingMon.equivalentOrLowerQualificationId
    left join funding_completion fundingComp on fundingComp.id=fundingMon.fundingCompletionId
    left join funding_length fundingLeng on fundingLeng.id=fundingMon.fundingLengthId
    left join non_regulated_fee_flag nonReg on nonReg.id=fundingMon.nonRegulatedFeeFlagId
    
    left join student_joint_degree stuJointDegree on stuJointDegree.personId = prn.id
    left join economic_information eco on eco.person_Id=prn.id
    left join drop_down isScholarship on isScholarship.id=eco.is_scholarship
    left join drop_down schoolFeePerYears on schoolFeePerYears.id=eco.school_fee_per_year
    left join drop_down parentAnnualIncome on parentAnnualIncome.id=eco.parent_annual_income
    
    LEFT JOIN placement_type pts on pbpc.placementTypeId=pts.id
    LEFT JOIN placement_campus campus on pts.id=campus.placementTypeId
    LEFT JOIN activity_duration_type adt on campus.activityDurationTypeId=adt.id
    LEFT JOIN activity_type_identifier ati on campus.activityTypeIdentifierId=ati.id
    LEFT JOIN host_identifier hosti on campus.hostIdentifierId=hosti.id
    LEFT JOIN host_identifier_type hit on campus.hostIdentifierTypeId=hit.id
    LEFT JOIN mobile_scheme mobSch on campus.mobileSchemeId=mobSch.id
    LEFT JOIN country cc on campus.countryId=cc.id

  LEFT JOIN academy_location al ON al.id = adm.academyLocationId
 
    WHERE pbpc.academicTermId = academicTermId
      AND ps.id = programId
    GROUP BY adm.id,ps.id;

END $$ 
DELIMITER ;