DELIMITER $$
DROP PROCEDURE IF EXISTS V20250707115620__Create_ICICI_Payment_Child $$
CREATE PROCEDURE V20250707115620__Create_ICICI_Payment_Child()
BEGIN

SET SQL_SAFE_UPDATES = 0;

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'icici_payment_gateway') THEN
    CREATE TABLE `icici_payment_gateway` (
        `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
        `academyLocationId` BIGINT(20) NOT NULL,
        `merchantId` VARCHAR(1000),
        `paymentMode` VARCHAR(1000),
        `aesKey` VARCHAR(1000),
        `currencyCode` VARCHAR(1000),
        `submerchantId` VARCHAR(1000),
        `environmentURL` VARCHAR(1000),
		`cipherKey` VARCHAR(1000),
        `customCol1` VARCHAR(1000),
        `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        `lastUpdatedBy` BIGINT(20) NOT NULL,
        PRIMARY KEY (`id`),
            INDEX `fk_academylocationid_icici_idx` (`academyLocationId` ASC),
            INDEX `fk_icici_payment_gateway_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_icici_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_icici_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT

    );
END IF;

IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'icici_payment_gateway' LIMIT 1) THEN
    SET @standardMasterMaxId = (SELECT COALESCE(MAX(id), 0) FROM standard_master);
    INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
    VALUES (@standardMasterMaxId + 1, 'icici_payment_gateway', 'Icici', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
END IF;

SET @standardMasterId = (
    SELECT id FROM standard_master
    WHERE tableName = 'icici_payment_gateway'
    ORDER BY id DESC LIMIT 1
);

IF @standardMasterId IS NOT NULL THEN
    UPDATE `standard_master`
    SET `childMaster` = @standardMasterId, `whetherParent` = 1
    WHERE `tableName` = 'standard_payment_gateway';

    IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'Icici') THEN
        INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)
        VALUES (@standardMasterId, 'Icici', false, NOW(), 1);
    END IF;

    -- Standard master items
    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'merchantId' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('merchantId', 'MERCHANT_ID', @standardMasterId, 'Varchar', 1, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;

    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'paymentMode' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('paymentMode', 'PAYMENT_MODE', @standardMasterId, 'Varchar', 2, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;

    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'aesKey' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('aesKey', 'AES_KEY', @standardMasterId, 'Varchar', 3, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;

    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currencyCode' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('currencyCode', 'CURRENCY_CODE', @standardMasterId, 'Varchar', 4, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;

    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'submerchantId' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('submerchantId', 'SUBMERCHANT_ID', @standardMasterId, 'Varchar', 5, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;

    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'environmentURL' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('environmentURL', 'ENVIRONMENT_URL', @standardMasterId, 'Varchar', 6, 0, 0, 0, 0, 1, SYSDATE(), 1000);
    END IF;

   IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
        END IF;

    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customCol1' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('customCol1', 'CUSTOMCOL1', @standardMasterId, 'Varchar', 8, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;

    IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'cipherKey' AND standardMasterId = @standardMasterId) THEN
        INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
        VALUES ('cipherKey', 'CIPHER_KEY', @standardMasterId, 'Varchar', 9, 0, 0, 0, 1, 1, SYSDATE(), 1000);
    END IF;

END IF;

SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20250707115620__Create_ICICI_Payment_Child () $$ 
DROP PROCEDURE IF EXISTS V20250707115620__Create_ICICI_Payment_Child $$ 
DELIMITER ;