DELIMITER $$
DROP PROCEDURE IF EXISTS V20250714102245__Insert_newFieldsInEducationHistoryDFR $$
CREATE PROCEDURE V20250714102245__Insert_newFieldsInEducationHistoryDFR()
BEGIN

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'educationform' and formFieldId='symbolLevelId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('educationform', 'symbolLevel', 'symbolLevelId', 'textfield', 0, 0, Null, 1, Now(), 'Symbol/Level', '1', 'Education History', 'Create, Edit, and View', 'Symbol/Level', 0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'educationform' and formFieldId='percentageId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('educationform', 'percent', 'percentageId', 'numberfield', 0, 0, Null, 1, Now(), 'Percentage', '1', 'Education History', 'Create, Edit, and View', 'Percentage', 0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'educationform' and formFieldId='passTypeItemId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('educationform', 'passType', 'passTypeItemId', 'customcombobox', 0, 0, Null, 1, Now(), 'Pass Type', '1', 'Education History', 'Create, Edit, and View', 'Pass Type', 0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'educationform' and formFieldId='yearCurrentLastSchoolAttendedId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('educationform', 'startYearCurrentOrLastSchoolAttended', 'yearCurrentLastSchoolAttendedId', 'numberfield', 0, 0, Null, 1, Now(), 'Start Year At Current School or Last School Attended', '1', 'Education History', 'Create, Edit, and View', 'Start Year At Current School or Last School Attended', 0);
END IF;

IF NOT EXISTS ((select * FROM `form_field_info` WHERE formAliasName = 'educationform' and formFieldId='startYearOFHighestQualificationId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`) 
VALUES ('educationform', 'startYearAtSchoolHighestQaulificatioAttended', 'startYearOFHighestQualificationId', 'numberfield', 0, 0, Null, 1, Now(), 'Start Year At School Where Highest Qualification Achieved', '1', 'Education History', 'Create, Edit, and View', 'Start Year At School Where Highest Qualification Achieved', 0);
END IF;

END $$
CALL V20250714102245__Insert_newFieldsInEducationHistoryDFR() $$
DROP PROCEDURE IF EXISTS V20250714102245__Insert_newFieldsInEducationHistoryDFR $$
DELIMITER ;