DELIMITER $$
DROP PROCEDURE IF EXISTS V20250731113143__Create_general_survey_csm $$
CREATE PROCEDURE V20250731113143__Create_general_survey_csm()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='general_survey_csm')) THEN 
CREATE TABLE `general_survey_csm` (
	`id` bigint NOT NULL AUTO_INCREMENT,
	`surveyToken` varchar(255) NOT NULL,
	`surveyName` varchar(255) NOT NULL,
	`surveyKey` varchar(255) NOT NULL,
	`surveyUrl` varchar(255) NOT NULL,
	`isAdmin` BIT(1) NULL DEFAULT 0 ,
	`isFaculty` BIT(1) NULL DEFAULT 0 ,
	`isStudent` BIT(1) NULL DEFAULT 0  ,
	`isParent` BIT(1) NULL DEFAULT 0 ,
	`lastUpdatedBy` bigint DEFAULT NULL,
	`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	KEY `general_survey_csm_lastUpdatedBy` (`lastUpdatedBy`),
   CONSTRAINT `general_survey_csm_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
  );
  
  
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'general_survey_csm','GENERAL_SURVEY','Tools & Services','COMMON_MASTER',0,0,NULL,1,now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'surveyName', 'SURVEY_NAME', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'surveyKey', 'SURVEY_KEY', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'surveyUrl', 'SURVEY_URL', @standardMasterMaxId+1, 'varchar', '3', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'surveyToken', 'SURVEY_TOKEN', @standardMasterMaxId+1, 'varchar', '4', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isAdmin', 'IS_ADMIN_PORTAL', @standardMasterMaxId+1, 'Boolean', '5', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isFaculty', 'IS_FACULTY_PORTAL', @standardMasterMaxId+1, 'Boolean', '6', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isStudent', 'IS_STUDENT_PORTAL', @standardMasterMaxId+1, 'Boolean', '7', 0, 0, 0, 0, '1', now());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isParent', 'IS_PARENT_PORTAL', @standardMasterMaxId+1, 'Boolean', '8', 0, 0, 0, 0, '1', now());

END IF; 


 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='GENERAL_SURVEY' and objectName='masterNames')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
 VALUES ('masterNames','GENERAL_SURVEY','General Survey','General Survey','Algemene Opmeting','Khảo sát chung',now(),1);
 END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='SURVEY_NAME' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SURVEY_NAME','Survey Name','Survey Name','Opname Naam','Tên khảo sát',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='SURVEY_KEY' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SURVEY_KEY','Survey Key','Survey Key','Opnamesleutel','Chìa khóa khảo sát',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='SURVEY_URL' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SURVEY_URL','Survey URL','Survey URL','Opname-URL','URL khảo sát',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='SURVEY_TOKEN' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SURVEY_TOKEN','Survey Token','Survey Token','Opnameteken','Mã thông báo khảo sát',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='IS_ADMIN_PORTAL' and objectName='TRANSLATIONS')) THEN  
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','IS_ADMIN_PORTAL','Administrator','Administrator','Administrateur','Quản trị viên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='IS_FACULTY_PORTAL' and objectName='TRANSLATIONS')) THEN   
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','IS_FACULTY_PORTAL','Faculty','Faculty','Fakulteit','Khoa',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='IS_STUDENT_PORTAL' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','IS_STUDENT_PORTAL','Student','Student','Student','Học sinh',now(),1);
END IF;


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='IS_PARENT_PORTAL' and objectName='TRANSLATIONS')) THEN  
INSERT INTO `ui_translation` ( `objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('TRANSLATIONS','IS_PARENT_PORTAL','Parent','Parent','Ouer','Phụ huynh',now(),1);
END IF;


END $$
CALL V20250731113143__Create_general_survey_csm () $$ 
DROP PROCEDURE IF EXISTS V20250731113143__Create_general_survey_csm $$ 
DELIMITER ;