DELIMITER $$
DROP PROCEDURE IF EXISTS V20250804130350__Create_Doku_Payment_Child $$
CREATE PROCEDURE V20250804130350__Create_Doku_Payment_Child()
BEGIN

SET SQL_SAFE_UPDATES = 0;

IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'doku_payment_gateway') THEN
        CREATE TABLE `doku_payment_gateway` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `academyLocationId` BIGINT(20) NOT NULL,
			`checkoutURL` VARCHAR(1000),
			`clientId` VARCHAR(1000),
            `secretKey` VARCHAR(1000),
			`currencyCode` VARCHAR(1000),
            `customfield1` VARCHAR(1000),
            `customfield2` VARCHAR(1000),
           `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `lastUpdatedBy` BIGINT(20) NOT NULL,
            PRIMARY KEY (`id`),
            INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
            INDEX `fk_doku_payment_gateway_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_doku_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_doku_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT
        );
    END IF;

    IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'doku_payment_gateway' LIMIT 1) THEN
        SET @standardMasterMaxId = (SELECT COALESCE(MAX(id)) FROM standard_master);
       
        INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
        VALUES (@standardMasterMaxId + 1, 'doku_payment_gateway', 'Doku', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
    END IF;

    SET @standardMasterId = (SELECT id FROM standard_master WHERE `tableName` = 'doku_payment_gateway' order by  id desc limit 1);

    IF @standardMasterId IS NOT NULL THEN
        UPDATE `standard_master` SET `childMaster` = @standardMasterId, `whetherParent` = 1 WHERE `tableName` = 'standard_payment_gateway';

        IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'Doku') THEN
            INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)  
            VALUES (@standardMasterId, 'Doku', false, NOW(), 1);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'checkoutURL' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('checkoutURL', 'CHECKOUT_URL', @standardMasterId, 'Varchar', 2, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'clientId' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('clientId', 'CLIENT_ID', @standardMasterId, 'Varchar', 3, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'secretKey' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('secretKey', 'SECRET_KEY', @standardMasterId, 'Varchar', 4, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currencyCode' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('currencyCode', 'CURRENCY_CODE', @standardMasterId, 'Varchar', 5, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        
         IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customfield1' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('customfield1', 'CUSTOMFIELD1', @standardMasterId, 'Varchar', 6, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customfield2' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('customfield2', 'CUSTOMFIELD2', @standardMasterId, 'Varchar', 7, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
     
    END IF;
    SET SQL_SAFE_UPDATES = 1; 

END $$
CALL V20250804130350__Create_Doku_Payment_Child () $$ 
DROP PROCEDURE IF EXISTS V20250804130350__Create_Doku_Payment_Child $$ 
DELIMITER ;