DELIMITER $$

DROP PROCEDURE IF EXISTS V20250805170530__Alter_AlterUserSocial $$

CREATE PROCEDURE V20250805170530__Alter_AlterUserSocial()
BEGIN
    -- Check if table exists
    IF EXISTS (
        SELECT 1 FROM information_schema.TABLES
        WHERE table_schema = DATABASE()
          AND table_name = 'users_social'
    ) THEN
        
        -- Check if userAccessToken column exists
        IF NOT EXISTS (
            SELECT 1 FROM information_schema.COLUMNS
            WHERE table_schema = DATABASE()
              AND table_name = 'users_social'
              AND column_name = 'userAccessToken'
        ) THEN
            ALTER TABLE users_social ADD COLUMN userAccessToken VARCHAR(4096) NULL;
        ELSE
            -- If column exists but is too small, modify it
            ALTER TABLE users_social MODIFY COLUMN userAccessToken VARCHAR(4096) NULL;
        END IF;
        
        -- Check if tokenExpiry column exists
        IF NOT EXISTS (
            SELECT 1 FROM information_schema.COLUMNS
            WHERE table_schema = DATABASE()
              AND table_name = 'users_social'
              AND column_name = 'tokenExpiry'
        ) THEN
            ALTER TABLE users_social ADD COLUMN tokenExpiry TIMESTAMP NULL;
        END IF;

    END IF;
END $$

DELIMITER ;

-- Now call the procedure separately
CALL V20250805170530__Alter_AlterUserSocial();

-- Optional: Drop the procedure after execution
DROP PROCEDURE IF EXISTS V20250805170530__Alter_AlterUserSocial;