DELIMITER $$
DROP PROCEDURE IF EXISTS V20250806123241__Create_SouthAfricanNationalIdValiation $$
CREATE PROCEDURE V20250806123241__Create_SouthAfricanNationalIdValiation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='south_african_nationalid_validation')) THEN 
CREATE TABLE `south_african_nationalid_validation` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`relavantToFormType` VARCHAR(100) NOT NULL,
	`dateOfBirth` boolean DEFAULT FALSE,
    `gender` boolean DEFAULT FALSE,
    `citizenship` boolean DEFAULT FALSE,
    `race` boolean DEFAULT FALSE,
    `checksum` boolean DEFAULT FALSE,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY relavantToFormType_UNIQUE (relavantToFormType),
	CONSTRAINT `south_african_nationalid_validation_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'south_african_nationalid_validation')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'south_african_nationalid_validation','SOUTH_AFRICAN_VALIDATION','Admissions','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((SELECT * FROM standard_master WHERE tableName = 'south_african_nationalid_validation')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'south_african_nationalid_validation');
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='RELEVANT_TO')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('relavantToFormType','RELEVANT_TO',@standardMasterId,'Enum','RELEVANT_TO',1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='DATE_OF_BIRTH')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('dateOfBirth','DATE_OF_BIRTH',@standardMasterId,'boolean',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='GENDER')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('gender','GENDER',@standardMasterId,'boolean',NULL,3,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='CITIZENSHIP')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('citizenship','CITIZENSHIP',@standardMasterId,'boolean',NULL,4,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='RACE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('race','RACE',@standardMasterId,'boolean',NULL,5,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='CHECKSUM')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('checksum','CHECKSUM',@standardMasterId,'boolean',NULL,6,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

END IF;


	IF NOT EXISTS ((SELECT * FROM `picklist_enum` WHERE enumType='RELEVANT_TO' and code='ONLINE_ENQUIRY_FORM')) THEN 
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('RELEVANT_TO', 'ONLINE_ENQUIRY_FORM', 'Online Enquiry Form');
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM `picklist_enum` WHERE enumType='RELEVANT_TO' and code='ONLINE_SINGUP_FORM')) THEN 
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('RELEVANT_TO', 'ONLINE_SINGUP_FORM', 'Online Sign Form');
	END IF; 
    
		IF NOT EXISTS ((SELECT * FROM `picklist_enum` WHERE enumType='RELEVANT_TO' and code='APPLICATION')) THEN 
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('RELEVANT_TO', 'APPLICATION', 'Application');
	END IF; 
    
		IF NOT EXISTS ((SELECT * FROM `picklist_enum` WHERE enumType='RELEVANT_TO' and code='IMPORT_BULK_APPLICATION')) THEN 
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('RELEVANT_TO', 'IMPORT_BULK_APPLICATION', 'Import Bulk Application');
	END IF; 
    
		IF NOT EXISTS ((SELECT * FROM `picklist_enum` WHERE enumType='RELEVANT_TO' and code='DIRECT_ADMISSION')) THEN 
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('RELEVANT_TO', 'DIRECT_ADMISSION', 'Direct Admission');
	END IF; 
    
		IF NOT EXISTS ((SELECT * FROM `picklist_enum` WHERE enumType='RELEVANT_TO' and code='IMPORT_BULK_ADMISSION')) THEN 
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('RELEVANT_TO', 'IMPORT_BULK_ADMISSION', 'Import Bulk Admission');
	END IF; 
	
END $$
CALL V20250806123241__Create_SouthAfricanNationalIdValiation () $$ 
DROP PROCEDURE IF EXISTS V20250806123241__Create_SouthAfricanNationalIdValiation $$ 
DELIMITER ;