DELIMITER $$

DROP PROCEDURE IF EXISTS V20250808110422__Create_ajdl_index_opt $$

CREATE PROCEDURE V20250808110422__Create_ajdl_index_opt()
BEGIN
    -- Check if index does not exist
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.statistics
        WHERE table_schema = DATABASE()
          AND table_name = 'academia_job_detail_logs'
          AND index_name = 'idx_job_detail_job_start_end'
    ) THEN
        CREATE INDEX idx_job_detail_job_start_end 
        ON academia_job_detail_logs(jobName, startTime, endTime);
    END IF;
END $$

-- Call the procedure
CALL V20250808110422__Create_ajdl_index_opt() $$

-- Drop the procedure after execution
DROP PROCEDURE IF EXISTS V20250808110422__Create_ajdl_index_opt $$

DELIMITER ;
