DELIMITER $$
DROP PROCEDURE IF EXISTS V20250813125322__Update_SERVICE_REQUEST_STUDENT_CREATION_DL $$
CREATE PROCEDURE V20250813125322__Update_SERVICE_REQUEST_STUDENT_CREATION_DL()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @srStudentCreation=(SELECT id FROM dtprovider WHERE `dataProviderName`='SERVICE_REQUEST_STUDENT_CREATION_DL');
IF @srStudentCreation IS NOT NULL THEN
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS USER_ID
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.requester
		LEFT JOIN
    request_types T4 ON T4.id = T2.requestTypeId
		LEFT JOIN
    drop_down dd ON dd.name='Readmission Email Configuration'  
WHERE 
    T1.id IN (namedParams)
    <MSG@ACAD_LOC_CRITERIA>
        AND T2.academyLocationId IN (msg_scope_acad_loc_Ids)
        AND ((LOWER(dd.value) = 'yes' AND T4.requestTypeName = 'Readmission Request')
            OR 
            (LOWER(dd.value) = 'no' OR dd.value IS NULL))
    </MSG>" WHERE `dataProviderId`=@srStudentCreation;
END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250813125322__Update_SERVICE_REQUEST_STUDENT_CREATION_DL () $$
DROP PROCEDURE IF EXISTS V20250813125322__Update_SERVICE_REQUEST_STUDENT_CREATION_DL $$
DELIMITER ;