DELIMITER $$
DROP PROCEDURE IF EXISTS V20250909175817__Create_NotificationForGraduationEvent $$
CREATE PROCEDURE V20250909175817__Create_NotificationForGraduationEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM system_msg_event WHERE `code`='NOTIFICATION_FOR_GRADUATION' limit 1)) THEN
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='PROGRAM_AND_COURSE');
IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='STUDENT_NOTIFICATION_FOR_GRADUATION' and parentCategory=@parentcategoryId limit 1)) THEN
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+2,@parentcategoryId,'STUDENT_NOTIFICATION_FOR_GRADUATION');
END IF;

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT_NOTIFICATION_FOR_GRADUATION');

IF NOT EXISTS ((SELECT * FROM system_msg_event WHERE `code`='NOTIFICATION_FOR_GRADUATION')) THEN
INSERT INTO `system_msg_event`
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'NOTIFICATION_FOR_GRADUATION', 'Notification for Graduation', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'NOTIFICATION_FOR_GRADUATION');
END IF;

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1 , @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'NOTIFICATION_FOR_GRADUATION_DL', 'SQL');

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'NOTIFICATION_FOR_GRADUATION_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NOTIFICATION_FOR_GRADUATION_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'NOTIFICATION_FOR_GRADUATION_RCPNT');


-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NOTIFICATION_FOR_GRADUATION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='NOTIFICATION_FOR_GRADUATION_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NOTIFICATION_FOR_GRADUATION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT
    T1.id AS USER_ID
FROM
    completions T1   
WHERE
    T1.id IN (namedParams)",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='NOTIFICATION_FOR_GRADUATION_RCPNT');
IF NOT EXISTS ((SELECT * FROM sql_dtprovider WHERE `dataProviderId`=@dtproviderId)) THEN
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select DISTINCT 
    T1.id As ID ,
    T3.code AS STUDENT_ID,
    p.printName AS STUDENT_PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.middleName AS MIDDLE_NAME,
    p.lastName AS LAST_NAME,
    p.mobileNumber AS MOBILE_NO,
    p.emailId AS EMAIL_ID,
    T9.programNameToBePrint AS STUDENT_ADMITTED_PROGRAM_NAME,
    T9.programCode AS STUDENT_ADMITTED_PROGRAM_CODE,
    T10.printName AS STUDENT_BATCH,
    T12.printName AS STUDENT_GRADUATED_PERIOD_NAME,
    T13.itemValue AS STUDENT_GRADUATED_ACADEMIC_TERM, 
    T8.websiteURL AS ACADEMY_LOCATION_WEBSITE_URL,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_IMAGE_URL,
    (CASE
        WHEN
            T5.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        ELSE NULL
    END) AS FOOTER_IMAGE_URL,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_LOCATION_DISPLAY_NAME,
    T8.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T8.phoneCountryCode AS ACADEMY_LOCATION_PHONE_CODE,
    T8.phoneAreaCode AS ACADEMY_LOCATION_PHONE_AREA_CODE,
    T8.phoneNo AS ACADEMY_LOCATION_PHONE_NO,
    T8.cellCountryCode AS ACADEMY_LOCATION_MOBILE_CODE,
    T8.cellNo AS ACADEMY_LOCATION_MOBILE_NO
 FROM completions T1
	LEFT JOIN
     students T2 ON T2.userId = T1.studentId
    LEFT JOIN  
    persons p on p.id = T2.personId
	LEFT JOIN
    users T3 ON T2.userId = T3.id
    LEFT JOIN
	admission T4 on T4.id = T1.admissionId
    LEFT JOIN
    academy_location T5 on T5.id = T4.academyLocationId
    LEFT JOIN 
    locations T6 on T6.id = T5.locationId
    LEFT JOIN 
    location_addresses T7 on T7.locationId = T6.id
    LEFT JOIN 
    address T8 on T8.id = T7.addressId
    LEFT JOIN
    programs T9 on T9.id = T1.programId
    LEFT JOIN 
    batches T10 on T10.id = T1.batchId
    LEFT JOIN 
    program_batch_students T11 on T11.id = T4.id
    LEFT JOIN 
    prog_batch_period_config T12 on T12.id = T11.progBatchPeriodConfigId
    LEFT JOIN 
    academic_term T13 on T13.id = T12.academicTermId
    LEFT JOIN    
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
    where T1.id in (namedParams);",'{
    "id": 1,
    "searchResultViewColumns": [
    {
        "id": 1,
        "value": "ID",
        "resultKey": "ID",
        "displayCode": "",
        "displayOrder": 0
    },
    {
        "id": 2,
        "value": "code",
        "resultKey": "STUDENT_ID",
        "displayCode": "",
        "displayOrder": 1
    },
    {
        "id": 3,
        "value": "printName",
        "resultKey": "STUDENT_PRINT_NAME",
        "displayCode": "",
        "displayOrder": 2
    },{
        "id": 4,
        "value": "firstName",
        "resultKey": "FIRST_NAME",
        "displayCode": "",
        "displayOrder": 3
    },{
        "id": 5,
        "value": "middleName",
        "resultKey": "MIDDLE_NAME",
        "displayCode": "",
        "displayOrder": 4
    },{
        "id": 6,
        "value": "lastName",
        "resultKey": "LAST_NAME",
        "displayCode": "",
        "displayOrder": 5
    },{
        "id": 7,
        "value": "mobileNumber",
        "resultKey": "MOBILE_NO",
        "displayCode": "",
        "displayOrder": 6
    },{
        "id": 8,
        "value": "emailId",
        "resultKey": "EMAIL_ID",
        "displayCode": "",
        "displayOrder": 7
    },
    {
        "id": 9,
        "value": "programNameToBePrint",
        "resultKey": "STUDENT_ADMITTED_PROGRAM_NAME",
        "displayCode": "",
        "displayOrder": 8
    },
    {
        "id": 10,
        "value": "programCode",
        "resultKey": "STUDENT_ADMITTED_PROGRAM_CODE",
        "displayCode": "",
        "displayOrder": 9
    },
    {
        "id": 11,
        "value": "printName",
        "resultKey": "STUDENT_BATCH",
        "displayCode": "",
        "displayOrder": 10
    },
    {
        "id": 12,
        "value": "printName",
        "resultKey": "STUDENT_GRADUATED_PERIOD_NAME",
        "displayCode": "",
        "displayOrder": 11
    },
    {
        "id": 13,
        "value": "itemValue",
        "resultKey": "STUDENT_GRADUATED_ACADEMIC_TERM",
        "displayCode": "",
        "displayOrder": 12
    },
    {
        "id": 14,
        "value": "websiteURL",
        "resultKey": "ACADEMY_LOCATION_WEBSITE_URL",
        "displayCode": "",
        "displayOrder": 13
    },
    {
        "id": 15,
        "value": "academyName",
        "resultKey": "ACADEMY_NAME",
        "displayCode": "",
        "displayOrder": 14
    },
    {
        "id": 16,
        "value": "locationName",
        "resultKey": "LOCATION_NAME",
        "displayCode": "",
        "displayOrder": 15
    },
    {
        "id": 17,
        "value": "displayName",
        "resultKey": "ACADEMY_LOCATION_DISPLAY_NAME",
        "displayCode": "",
        "displayOrder": 16
    },
    {
        "id": 18,
        "value": "primaryeEmailId",
        "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
        "displayCode": "",
        "displayOrder": 17
    },
    {
        "id": 19,
        "value": "phoneCountryCode",
        "resultKey": "ACADEMY_LOCATION_PHONE_CODE",
        "displayCode": "",
        "displayOrder": 18
    },
    {
        "id": 20,
        "value": "phoneAreaCode",
        "resultKey": "ACADEMY_LOCATION_PHONE_AREA_CODE",
        "displayCode": "",
        "displayOrder": 19
    },
    {
        "id": 21,
        "value": "phoneNo",
        "resultKey": "ACADEMY_LOCATION_PHONE_NO",
        "displayCode": "",
        "displayOrder": 20
    },
    {
        "id": 22,
        "value": "cellCountryCode",
        "resultKey": "ACADEMY_LOCATION_MOBILE_CODE",
        "displayCode": "",
        "displayOrder": 21
    },
    {
        "id": 23,
        "value": "cellNo",
        "resultKey": "ACADEMY_LOCATION_MOBILE_NO",
        "displayCode": "",
        "displayOrder": 22
    },
    {
        "id": 24,
        "value": "HEADER_IMAGE_URL",
        "resultKey": "HEADER_IMAGE_URL",
        "displayCode": "",
        "displayOrder": 23
    },
    {
        "id": 25,
        "value": "FOOTER_IMAGE_URL",
        "resultKey": "FOOTER_IMAGE_URL",
        "displayCode": "",
        "displayOrder": 24
    }
] }');
END IF;

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='NOTIFICATION_FOR_GRADUATION');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='STUDENT_NOTIFICATION_FOR_GRADUATION');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='NOTIFICATION_FOR_GRADUATION_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`)
VALUES(@msgtemplateconfigId+1,'Notification For Graduation',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Notification For Graduation',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);

IF NOT EXISTS ((SELECT * FROM msg_template WHERE `subjectLine`='Graduation Confirmation' limit 1)) THEN
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
VALUES(@msgtemplateId+1,@msgtemplateconfigId+1,'1','Graduation Confirmation','<html>
<head>
  <title>Graduation Confirmation</title>
</head>
<body>
  <p>Dear <strong> $recipientData["STUDENT_PRINT_NAME"] </strong>,</p>

  <p>Congratulations &ndash; we confirm your eligibility to graduate! For your convenience, we have attached your Qualification Completion Letter, and you will find your Final Academic Transcript in your student portal.</p>

  <p>We encourage you to download these and any other important documents at your earliest convenience, as after <strong>6 months</strong> your student portal will be made <strong>inactive</strong>.</p>

  <p>All the best with your future endeavours.</p>

  <p>Kind regards,<br />
  <strong>The $recipientData["ACADEMY_LOCATION_DISPLAY_NAME"] </strong><br />
  <strong>Email:</strong> <a href="mailto:$recipientData["ACADEMY_LOCATION_EMAIL_ID"]">$recipientData["ACADEMY_LOCATION_EMAIL_ID"]</a><br />
  <strong>Phone Number:</strong> $recipientData["ACADEMY_LOCATION_PHONE_CODE"]  $recipientData["ACADEMY_LOCATION_PHONE_NO"] <br />
  <strong>WhatsApp Number:</strong> $recipientData["ACADEMY_LOCATION_MOBILE_CODE"]  $recipientData["ACADEMY_LOCATION_MOBILE_NO"]<br />
  <strong>Website:</strong> <a href="$recipientData["ACADEMY_LOCATION_WEBSITE_URL"]" target="_blank">$recipientData["ACADEMY_LOCATION_WEBSITE_URL"]</a>
  </p>
</body>
</html>
');

END IF; 

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`)
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["STUDENT_PRINT_NAME"], congratulations &ndash; we confirm your eligibility to graduate. Please check your student portal to download your qualification completion letter and your transcript.');

END IF;

END $$
CALL V20250909175817__Create_NotificationForGraduationEvent () $$ 
DROP PROCEDURE IF EXISTS V20250909175817__Create_NotificationForGraduationEvent $$ 
DELIMITER ;