DELIMITER $$
DROP PROCEDURE IF EXISTS V20250918165216__Insert_FeePayerDocTemp $$
CREATE PROCEDURE V20250918165216__Insert_FeePayerDocTemp()
BEGIN

IF EXISTS ((SELECT * FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_AMENDMENT_AUTHORIZATION_INFO')) THEN
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT MAX(dataProviderId) FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_AMENDMENT_AUTHORIZATION_INFO');
IF NOT EXISTS ((SELECT 1 FROM `dydt_data_line_item` where `dataSourceCode`='FEE_PAYER_DECLARATION_DESCRIPTION' AND `dataProviderId` = @dydtdataproviderId)) THEN
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'FEE_PAYER_DECLARATION_DESCRIPTION', '10',null, '1', '0', 
"SELECT
    CONCAT('On the <b>[',
            DATE_FORMAT(NOW(), '%d/%m/%Y %I:%i'),
            ']</b> you accepted the Debit Order Mandate hereby authorising The <b>',
            concat(al.displayName,' (The ',al.locationCode,')</b>'),
            ' to issue and deliver payment instructions to the bank for collection against the above-mentioned bank account on condition that the sum of such payment instructions will never exceed my obligations as agreed to in the Agreement, and commencing on the date and continuing until this Authority and Mandate is terminated by myself by giving The ',al.locationCode,' notice in writing of no less than 20 working days.') AS FEE_PAYER_DECLARATION_DESCRIPTION
FROM
    academy_location al 
    join admission admi on admi.academyLocationId=al.id", 
    'PRM_STUDENT_ID', 
	'FEE_PAYER_DECLARATION_DESCRIPTION',
"where admi.id=PRM_STUDENT_ID",false);    
        
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('FEE_PAYER_DECLARATION_DESCRIPTION', 'Fee Payer Declaration Description',@dydtdatalinitemId+1);
END IF; 
END IF;

END $$
CALL V20250918165216__Insert_FeePayerDocTemp() $$
DROP PROCEDURE IF EXISTS V20250918165216__Insert_FeePayerDocTemp $$
DELIMITER ;