DELIMITER $$
DROP PROCEDURE IF EXISTS V20251014145551__Insert_BuzzBothoUnofficialTranscript $$
CREATE PROCEDURE V20251014145551__Insert_BuzzBothoUnofficialTranscript()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' limit 1);

IF NOT EXISTS(select * from report_template where templateCode = 'BOTHO_UNOFFICIAL_TRANSCRIPT') THEN 
INSERT INTO report_template (reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, templateType, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo) 
VALUES (@reportTypeTempId, 'BOTHO_UNOFFICIAL_TRANSCRIPT', 'Botho Unofficial Transcript', 'BOTHO_UNOFFICIAL_TRANSCRIPT.png', 'CommonReport_BOTHO_UNOFFICIAL_TRANSCRIPT.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'BOTHO_UNOFFICIAL_TRANSCRIPT.jasper', 'AcademiaLogo.png');
END IF;     

set @tempId = (select max(id) from report_template where templateCode='BOTHO_UNOFFICIAL_TRANSCRIPT');


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_SPECIALIZATION' limit 1) THEN 
INSERT INTO report_template_translations (reportTemplateId, keyValue, defaultValue, lastUpdatedBy, lastUpdate)
VALUES (@tempId, 'TRANS_SPECIALIZATION', 'SPECIALIZATION', '1', now());
END IF; 


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CONFERRED_DATE' limit 1) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CONFERRED_DATE', 'CONFERRED DATE', '1', now());
END IF; 



END $$
CALL V20251014145551__Insert_BuzzBothoUnofficialTranscript() $$
DROP PROCEDURE IF EXISTS V20251014145551__Insert_BuzzBothoUnofficialTranscript $$
DELIMITER ;