
DELIMITER $$
DROP PROCEDURE IF EXISTS V20251027142637__Create_StudentMedicalDetailsDataProvider $$
CREATE PROCEDURE V20251027142637__Create_StudentMedicalDetailsDataProvider()
BEGIN

SET @dataProviderId=(SELECT MAX(id) FROM `dydt_data_provider` where providerName='Registration Confirmation on Period Enrollment');
 SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
IF NOT EXISTS ((SELECT 1 FROM dydt_data_line_item WHERE dataSourceCode='STUDENT_MEDICAL_CONDITION_INFO'  AND dataProviderId = @dataProviderId)) THEN 

INSERT INTO `dydt_data_line_item` (`id`,`dataProviderId`,`dataSourceCode`,`executionOrder`,`publishAsParametersDef`,`whetherDataSource`,`whetherPrimaryDataSource`,`sqlSelectQueryDef`,`whereClauseBindingDef`,`resultColumnsDef`,`formattersDef`,`sqlWhereQueryDef`,`whetherMultiRecord`)
 VALUES (@dydtdatalinitemId+1,@dataProviderId,'STUDENT_MEDICAL_CONDITION_INFO',3,NULL,1,0,"SELECT 
        mct.itemCode as CONDITION_TYPE,
        mh.medicalCondition as MEDICAL_CONDITION,
        mh.remarks AS PRECAUTION_MEDICALTION
 FROM admission adm 
    LEFT JOIN users u 
         ON u.id=adm.studentId
    LEFT JOIN students stud 
         ON stud.userId=u.id
    LEFT JOIN  medical_history mh 
         ON mh.personId = stud.personId
    LEFT JOIN  medical_condition_types mct 
         ON mct.id = mh.medicalConditonId",'PRM_STUDENT_ID','CONDITION_TYPE,MEDICAL_CONDITION,PRECAUTION_MEDICATION',NULL,'WHERE adm.id=PRM_STUDENT_ID and mh.whetherDeleted=FALSE',1);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('CONDITION_TYPE', 'Condition Type',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MEDICAL_CONDITION', 'Medical Condition',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PRECAUTION_MEDICATION', 'Percaution Medication',@dydtdatalinitemId+1);

END IF;
END $$
CALL V20251027142637__Create_StudentMedicalDetailsDataProvider () $$ 
DROP PROCEDURE IF EXISTS V20251027142637__Create_StudentMedicalDetailsDataProvider $$ 
DELIMITER ;