DELIMITER $$
DROP PROCEDURE IF EXISTS V20251027173435__Update_RegistrationConfirmationDynamicDoc $$
CREATE PROCEDURE V20251027173435__Update_RegistrationConfirmationDynamicDoc()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT 1 FROM `dydt_data_provider` where providerName='Registration Confirmation Letter Dynamic Document')) THEN 	
SET @dataProviderId=(SELECT MAX(id) FROM `dydt_data_provider` where providerName='Registration Confirmation Letter Dynamic Document');
END IF;

IF EXISTS ((SELECT 1 FROM dydt_data_line_item WHERE dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO' AND dataProviderId = @dataProviderId LIMIT 1)) THEN 	
 SET @dydtdatalinitemId=(SELECT MAX(id) FROM dydt_data_line_item WHERE dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO'  AND dataProviderId = @dataProviderId LIMIT 1);
END IF;

IF  EXISTS ((SELECT 1 FROM dydt_data_line_item WHERE dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO'  AND dataProviderId = @dataProviderId)) THEN  
update dydt_data_line_item set resultColumnsDef  ='APP_USERNAME,APP_FIRST_NAME,APP_MIDDLE_NAME,APP_LAST_NAME,APP_EMAIL_ID,
 APP_MOBILE_NO,APP_MOBILE_CODE,APP_PASSWORD,APP_PROGRAM_NAME,APP_INTAKE_NAME,APP_PERIOD_NAME,APP_STUDENT_ID,
 APP_ACADEMIC_TERM,APP_INTAKE_YEAR,APP_MODE_OF_DELIVERY,APP_REGISTRATION_TYPE,APP_INTAKE_START_DATE,
 APP_INTAKE_END_DATE,APP_ACADEMY_NAME,APP_LOCATION_NAME,APP_ACADEMY_LOCATION,APP_SEAT_TYPE,APP_PHONE_COUNTRY_CODE,APP_PHONE_AREA_CODE,
 APP_PHONE_NO,APP_CAMPUS_EMAILID,APP_CAMPUS_WEBSITE_URL,APP_STD_ADDRESS,APP_NATIONAL_ID,APP_ID_TYPE,APP_TITLE,APP_CAST_CATEGORY,APP_NATIONALITY,
 APP_HOME_LANGUAGE,APP_ADMISSION_DATE,APP_CURRENT_ADDRESS,APP_COUNTRY_NAME_STUDENT,APP_COUNTRY_REGION_STUDENT,APP_CITY_STUDENT,APP_POSTAL_CODE, 
 APP_PAYMENT_TERM,APP_REQUEST_RECEIVED_DATE,APP_EXAM_CENTER,SU_NUMBER,CURRENT_DATE_,ID_NUMBER,QUAL_MODE_OF_OFFERING,QUAL_MIN_DURATION_TIME,DATE_STAMP,PROGRAM_DISCONTINUATION_DETAILS 
 ,SCHEME,OPTION1,PRINCIPLE_MEMBER,MEMBERSHIP_NUMBER'
, whereClauseBindingDef='PRM_ADMISSION_ID', sqlSelectQueryDef = "SELECT DISTINCT
    T3.userId AS ID,
    T17.printName AS APP_USERNAME,
    T18.firstName AS APP_FIRST_NAME,
    T18.middleName AS APP_MIDDLE_NAME,
    T18.lastName AS APP_LAST_NAME,
    g.itemValue AS APP_GENDER,
    T18.emailId AS APP_EMAIL_ID,
    T18.alternateEmailId AS APP_ALTERNATE_EMAIL_ID,
    T18.birthDate AS APP_DATE_OF_BIRTH,
    T18.alternateMobileNo AS APP_ALTERNATE_MO_NO,
    T18.mobileNumber AS APP_MOBILE_NO,
    T18.mobileCountryCode AS APP_MOBILE_CODE,
    CONVERT(FROM_BASE64(T17.passwordBase64) USING UTF8) AS APP_PASSWORD,
    T5.programNameToBePrint AS APP_PROGRAM_NAME,
    T4.printName AS APP_INTAKE_NAME,
    T6.printName AS APP_PERIOD_NAME,
    T17.code AS APP_STUDENT_ID,
    T15.itemValue AS APP_ACADEMIC_TERM,
    T16.itemValue AS APP_INTAKE_YEAR,
    T20.itemValue AS APP_MODE_OF_DELIVERY,
    IF(T4.batchPartTime = TRUE, 'Part Time', 'Full Time') AS APP_REGISTRATION_TYPE,
    T4.startDate AS APP_INTAKE_START_DATE,
    T4.tillDate AS APP_INTAKE_END_DATE,
    T7.academyName AS APP_ACADEMY_NAME,
    T7.locationName AS APP_LOCATION_NAME,
    T7.displayName AS APP_ACADEMY_LOCATION,
    T14.seatName AS APP_SEAT_TYPE,
    T9.phoneCountryCode AS APP_PHONE_COUNTRY_CODE,
    T9.phoneAreaCode AS APP_PHONE_AREA_CODE,
    T9.phoneNo AS APP_PHONE_NO,
    T9.primaryeEmailId AS APP_CAMPUS_EMAILID,
    addr.websiteURL AS APP_CAMPUS_WEBSITE_URL,
    stdaddr.addressText AS APP_STD_ADDRESS,
    T18.nationalID AS APP_NATIONAL_ID,
    T22.idTypeName AS APP_ID_TYPE,
    T21.salutationName AS APP_TITLE,
    T39.itemValue AS APP_CAST_CATEGORY,
    T23.itemValue AS APP_NATIONALITY,
    T26.value AS APP_HOME_LANGUAGE,
    T2.admissionDate AS APP_ADMISSION_DATE,
    T29.addressText AS APP_CURRENT_ADDRESS,
    T36.countryName AS APP_COUNTRY_NAME_STUDENT,
    T37.countryRegionName AS APP_COUNTRY_REGION_STUDENT,
    T38.cityName AS APP_CITY_STUDENT,
    T29.pincode AS APP_POSTAL_CODE,
    pt.name AS APP_PAYMENT_TERM,
    T1.requestReceivedDate AS APP_REQUEST_RECEIVED_DATE,
    (SELECT itemValue 
     FROM student_course_enrollment scen 
     JOIN exam_center_csm eccsm ON eccsm.id = scen.examCenterId 
     WHERE scen.examCenterId IS NOT NULL 
       AND scen.admissionId = T2.id 
       AND scen.programBatchPeriodConfigId = T6.id 
     ORDER BY scen.examCenterId DESC 
     LIMIT 1) AS APP_EXAM_CENTER,
    T18.externalSysRefOne AS SU_NUMBER,
    DATE(NOW()) AS CURRENT_DATE_,
    T18.nationalID AS ID_NUMBER,
    program_mode_offering.itemValue AS QUAL_MODE_OF_OFFERING,
    program_other_details.programMinDurationTime AS QUAL_MIN_DURATION_TIME,
    DATE_FORMAT(NOW(), '%d %M %y') AS DATE_STAMP,
    CASE 
    WHEN LOWER(pcatc.itemCode) LIKE 'left%' 
         THEN DATE_FORMAT(pcd.awardRequestedDate, '%d %M %Y') 
    ELSE '' 
END AS PROGRAM_DISCONTINUATION_DETAILS ,
 md.scheme as SCHEME,
 md.option1 as OPTION1,
 md.principleMember as PRINCIPLE_MEMBER,
 md.membershipNumber as MEMBERSHIP_NUMBER
FROM
    program_batch_students T1
    LEFT OUTER JOIN admission T2 ON T1.admissionId = T2.id
    LEFT OUTER JOIN students T3 ON T2.studentId = T3.userId
    LEFT OUTER JOIN batches T4 ON T1.programBatchId = T4.id
    LEFT OUTER JOIN programs T5 ON T4.programId = T5.id
    LEFT OUTER JOIN prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
    LEFT OUTER JOIN program_completion_details pcd 
        ON pcd.admissionId = T2.id 
       AND T6.id = pcd.semester
    LEFT JOIN program_completion_award_type_csm pcatc 
        ON pcatc.id = pcd.awardTypeId   -- removed filter here
    LEFT OUTER JOIN academy_location T7 ON T7.id = T5.academyLocationId
    LEFT OUTER JOIN academy_location_addresses ala ON ala.academyLocationId = T7.id
    LEFT OUTER JOIN address addr ON addr.id = ala.addressId 
    LEFT OUTER JOIN locations T19 ON T19.id = T7.locationId
    LEFT OUTER JOIN location_addresses T8 ON T8.locationId = T19.id
    LEFT JOIN address T9 ON T9.id = T8.addressId
    LEFT OUTER JOIN city T10 ON T10.id = T9.cityId
    LEFT OUTER JOIN country T11 ON T11.id = T10.countryId
    LEFT OUTER JOIN country_region T12 ON T12.id = T10.countryRegionId
    LEFT OUTER JOIN prog_batch_seat_config T13 ON T13.id = T1.progBatchSeatConfigId
    LEFT OUTER JOIN seat_types T14 ON T14.id = T13.seatTypeId
    LEFT OUTER JOIN academic_term T15 ON T15.id = T6.academicTermId
    LEFT OUTER JOIN intake_year T16 ON T16.id = T4.intakeYearId
    LEFT OUTER JOIN users T17 ON T17.id = T3.userId
    LEFT OUTER JOIN persons T18 ON T18.id = T3.personId
    LEFT OUTER JOIN gender g ON g.id = T18.genderId
    LEFT OUTER JOIN person_addresses pa ON T18.id = pa.personId
        AND pa.whetherPrimary = TRUE
    LEFT OUTER JOIN address stdaddr ON pa.addressId = stdaddr.id
    LEFT JOIN mode_of_delivery T20 ON T20.id = T4.modeOfDeliveryId
    LEFT OUTER JOIN caste_categories T39 ON T39.id = T18.castCategoryId
    LEFT OUTER JOIN salutations T21 ON T21.id = T18.salutationId
    LEFT OUTER JOIN id_type T22 ON T22.id= T18.idTypeId
    LEFT OUTER JOIN nationalities T23 ON T23.id = T18.nationalityId
    LEFT OUTER JOIN drop_down T26 ON T26.id = T18.homeLanguage
    LEFT OUTER JOIN person_addresses T27 ON T27.personId = T18.id
    LEFT OUTER JOIN address_type T28 
        ON T28.id = T27.addressTypeId 
       AND T28.code = 'CRNT' 
       AND T28.addressCategory = 'PERSON'
    LEFT OUTER JOIN address T29 ON T29.id = T27.addressId
    LEFT OUTER JOIN city T38 ON T38.id = T29.cityId
    LEFT OUTER JOIN country_region T37 ON T37.id = T38.countryRegionId
    LEFT OUTER JOIN country T36 ON T36.id = T37.countryId
    LEFT OUTER JOIN payment_term pt ON pt.id = T1.paymentTermId
    LEFT OUTER JOIN program_other_details 
        ON T5.id = program_other_details.programId
    LEFT OUTER JOIN program_mode_offering 
        ON program_other_details.programModeOfferingId = program_mode_offering.id
	LEFT OUTER JOIN  medical_details md 
         ON md.personId = T3.personId"

where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO' AND dataProviderId = @dataProviderId;
END IF;

IF NOT EXISTS ((SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'SCHEME' and translationValue = 'Scheme' and dataProviderLineItemId=@dydtdatalinitemId)) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('SCHEME', 'Scheme',@dydtdatalinitemId);
END IF;

IF NOT EXISTS ((SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'OPTION1' and translationValue = 'Option' and dataProviderLineItemId=@dydtdatalinitemId)) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('OPTION1', 'Option',@dydtdatalinitemId);
END IF;

IF NOT EXISTS ((SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'PRINCIPLE_MEMBER' and translationValue = 'Principal Member' and dataProviderLineItemId=@dydtdatalinitemId)) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PRINCIPLE_MEMBER', 'Principal Member',@dydtdatalinitemId);
END IF;

IF NOT EXISTS ((SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'MEMBERSHIP_NUMBER' and translationValue = 'Membership No' and dataProviderLineItemId=@dydtdatalinitemId)) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MEMBERSHIP_NUMBER', 'Membership No',@dydtdatalinitemId);
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251027173435__Update_RegistrationConfirmationDynamicDoc () $$
DROP PROCEDURE IF EXISTS V20251027173435__Update_RegistrationConfirmationDynamicDoc $$
DELIMITER ;