DELIMITER $$
DROP PROCEDURE IF EXISTS V20251103152917__Insert_BulkPeriodConfigurable $$
CREATE PROCEDURE V20251103152917__Insert_BulkPeriodConfigurable()
BEGIN

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Periods' and  code ='period')) THEN 
INSERT INTO import_utility_master (screenName, fileDirectory, code, lastUpdate, lastUpdatedBy)
 VALUES ('Bulk Periods', 'periods/period', 'period', now(), '1');
END IF; 
IF EXISTS (SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Periods' and  code ='period') THEN 
SET @importUtilityMasterId=(SELECT id FROM import_utility_master where screenName = 'Bulk Periods' and  code ='period');

#========================= IS SCHOOL ===============================================================================================

-- ACADEMY_LOCATION
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='ACADEMY_LOCATION_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PROGRAM
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PROGRAM_HEADER', 'Program', 'Program', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- BATCH
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='BATCH_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('BATCH_HEADER', 'Batch', 'Batch', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PROGRAM_PERIOD
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_PERIOD_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PROGRAM_PERIOD_HEADER', 'Program Period', 'Program Period', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PRINT_NAME
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PRINT_NAME_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PRINT_NAME_HEADER', 'Print Name', 'Print Name', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- ACADEMIC_TERM
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='ACADEMIC_TERM_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('ACADEMIC_TERM_HEADER', 'Academic Term', 'Academic Term', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PERIOD_YEAR
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PERIOD_YEAR_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PERIOD_YEAR_HEADER', 'Period Year', 'Period Year', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- IS_LAST_PERIOD_OF_PROGRAM
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='IS_LAST_PERIOD_OF_PROGRAM_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('IS_LAST_PERIOD_OF_PROGRAM_HEADER', 'Is Last Period Of Program', 'Is Last Period Of Program', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- OPTIONAL_PERIOD
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='OPTIONAL_PERIOD_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('OPTIONAL_PERIOD_HEADER', 'Optional Period', 'Optional Period', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- START_DATE
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='START_DATE_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('START_DATE_HEADER', 'Start Date', 'Start Date', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- END_DATE
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='END_DATE_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('END_DATE_HEADER', 'End Date', 'End Date', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PERIOD_RANK_BASIS
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PERIOD_RANK_BASIS_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PERIOD_RANK_BASIS_HEADER', 'Period Rank Basis', 'Period Rank Basis', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_COURSES
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_COURSES_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_COURSES_HEADER', 'Minimum Courses', 'Minimum Courses', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MAXIMUM_COURSES
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MAXIMUM_COURSES_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MAXIMUM_COURSES_HEADER', 'Maximum Courses', 'Maximum Courses', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_CREDITS
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_CREDITS_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_CREDITS_HEADER', 'Minimum Credits', 'Minimum Credits', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MAXIMUM_CREDITS
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MAXIMUM_CREDITS_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MAXIMUM_CREDITS_HEADER', 'Maximum Credits', 'Maximum Credits', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- REGISTRATION_SETUP
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='REGISTRATION_SETUP_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('REGISTRATION_SETUP_HEADER', 'Registration Setup', 'Registration Setup', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- LAST_DATE_OF_ENROLLMENT
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='LAST_DATE_OF_ENROLLMENT_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('LAST_DATE_OF_ENROLLMENT_HEADER', 'Last Date Of Enrollment', 'Last Date Of Enrollment', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- ENROLLED_DIRECTLY
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='ENROLLED_DIRECTLY_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('ENROLLED_DIRECTLY_HEADER', 'Enrolled Directly', 'Enrolled Directly', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- REGISTRATION_PROCESS_REQUIRED
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='REGISTRATION_PROCESS_REQUIRED_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('REGISTRATION_PROCESS_REQUIRED_HEADER', 'Registration Process Required', 'Registration Process Required', '1', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_CREDITS_FOR_PROMOTION
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_CREDITS_FOR_PROMOTION_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_CREDITS_FOR_PROMOTION_HEADER', 'Minimum Credits for Promotion', 'Minimum Credits for Promotion', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_SGPA_FOR_PROMOTION
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_SGPA_FOR_PROMOTION_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_SGPA_FOR_PROMOTION_HEADER', 'Minimum SGPA for Promotion', 'Minimum SGPA for Promotion', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_CGPA_FOR_PROMOTION
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_CGPA_FOR_PROMOTION_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_CGPA_FOR_PROMOTION_HEADER', 'Minimum CGPA for Promotion', 'Minimum CGPA for Promotion', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- OFFERED_AT_ACADEMY_LOCATION
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='OFFERED_AT_ACADEMY_LOCATION_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('OFFERED_AT_ACADEMY_LOCATION_HEADER', 'Offered at Academy Location', 'Offered at Academy Location', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- CUA_COMPUTER_USER_AREA
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='CUA_COMPUTER_USER_AREA_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('CUA_COMPUTER_USER_AREA_HEADER', 'CUA (Computer User Area)', 'CUA (Computer User Area)', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_RESIDENCE_CREDIT
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_RESIDENCE_CREDIT_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_RESIDENCE_CREDIT_HEADER', 'Minimum Residence Credit', 'Minimum Residence Credit', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- HOME_ROOM
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='HOME_ROOM_HEADER' AND isSchool='1')) THEN
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('HOME_ROOM_HEADER', 'Home Room', 'Home Room', '1', NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;




#========================= IS COLLEGE ===============================================================
-- ACADEMY_LOCATION_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='ACADEMY_LOCATION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PROGRAM_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PROGRAM_HEADER', 'Program', 'Program', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- BATCH_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='BATCH_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('BATCH_HEADER', 'Batch', 'Batch', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PROGRAM_PERIOD_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_PERIOD_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PROGRAM_PERIOD_HEADER', 'Program Period', 'Program Period', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PRINT_NAME_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PRINT_NAME_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PRINT_NAME_HEADER', 'Print Name', 'Print Name', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- ACADEMIC_TERM_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='ACADEMIC_TERM_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('ACADEMIC_TERM_HEADER', 'Academic Term', 'Academic Term', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PERIOD_YEAR_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PERIOD_YEAR_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PERIOD_YEAR_HEADER', 'Period Year', 'Period Year', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- IS_LAST_PERIOD_OF_PROGRAM_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='IS_LAST_PERIOD_OF_PROGRAM_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('IS_LAST_PERIOD_OF_PROGRAM_HEADER', 'Is Last Period Of Program', 'Is Last Period Of Program', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- OPTIONAL_PERIOD_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='OPTIONAL_PERIOD_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('OPTIONAL_PERIOD_HEADER', 'Optional Period', 'Optional Period', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- START_DATE_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='START_DATE_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('START_DATE_HEADER', 'Start Date', 'Start Date', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- END_DATE_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='END_DATE_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('END_DATE_HEADER', 'End Date', 'End Date', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- PERIOD_RANK_BASIS_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='PERIOD_RANK_BASIS_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('PERIOD_RANK_BASIS_HEADER', 'Period Rank Basis', 'Period Rank Basis', '0', NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- REGISTRATION_PROCESS_REQUIRED_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId  AND headerCode='REGISTRATION_PROCESS_REQUIRED_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('REGISTRATION_PROCESS_REQUIRED_HEADER', 'Registration Process Required', 'Registration Process Required', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_COURSES_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_COURSES_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_COURSES_HEADER', 'Minimum Courses', 'Minimum Courses', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MAXIMUM_COURSES_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MAXIMUM_COURSES_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MAXIMUM_COURSES_HEADER', 'Maximum Courses', 'Maximum Courses', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_CREDITS_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_CREDITS_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_CREDITS_HEADER', 'Minimum Credits', 'Minimum Credits', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MAXIMUM_CREDITS_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MAXIMUM_CREDITS_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MAXIMUM_CREDITS_HEADER', 'Maximum Credits', 'Maximum Credits', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- REGISTRATION_SETUP_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='REGISTRATION_SETUP_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('REGISTRATION_SETUP_HEADER', 'Registration Setup', 'Registration Setup', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- LAST_DATE_OF_ENROLLMENT_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='LAST_DATE_OF_ENROLLMENT_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('LAST_DATE_OF_ENROLLMENT_HEADER', 'Last Date Of Enrollment', 'Last Date Of Enrollment', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- ENROLLED_DIRECTLY_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='ENROLLED_DIRECTLY_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('ENROLLED_DIRECTLY_HEADER', 'Enrolled Directly', 'Enrolled Directly', '0',NOW(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_CREDITS_FOR_PROMOTION_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_CREDITS_FOR_PROMOTION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_CREDITS_FOR_PROMOTION_HEADER', 'Minimum Credits for Promotion', 'Minimum Credits for Promotion', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_SGPA_FOR_PROMOTION_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_SGPA_FOR_PROMOTION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_SGPA_FOR_PROMOTION_HEADER', 'Minimum SGPA for Promotion', 'Minimum SGPA for Promotion', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_CGPA_FOR_PROMOTION_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='MINIMUM_CGPA_FOR_PROMOTION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_CGPA_FOR_PROMOTION_HEADER', 'Minimum CGPA for Promotion', 'Minimum CGPA for Promotion', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- OFFERED_AT_ACADEMY_LOCATION_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='OFFERED_AT_ACADEMY_LOCATION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('OFFERED_AT_ACADEMY_LOCATION_HEADER', 'Offered at Academy Location', 'Offered at Academy Location', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- CUA_COMPUTER_USER_AREA_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='CUA_COMPUTER_USER_AREA_HEADER'  AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('CUA_COMPUTER_USER_AREA_HEADER', 'CUA (Computer User Area)', 'CUA (Computer User Area)', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- MINIMUM_RESIDENCE_CREDIT_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId  AND headerCode='MINIMUM_RESIDENCE_CREDIT_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('MINIMUM_RESIDENCE_CREDIT_HEADER', 'Minimum Residence Credit', 'Minimum Residence Credit', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

-- HOME_ROOM_HEADER
IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@importUtilityMasterId AND headerCode='HOME_ROOM_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header(headerCode, defaultHeaderLabel, headerLabel, isSchool, lastUpdate, lastUpdatedBy,
 isNonEditable, isMandatory, importUtilityMasterId, isVisible, defaultValue)
VALUES ('HOME_ROOM_HEADER', 'Home Room', 'Home Room', '0',NOW(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;



END IF;
END $$
CALL V20251103152917__Insert_BulkPeriodConfigurable() $$
DROP PROCEDURE IF EXISTS V20251103152917__Insert_BulkPeriodConfigurable $$
DELIMITER ;