DELIMITER $$
DROP PROCEDURE IF EXISTS V20251114140019__Create_netsuiteReceipt_main $$
CREATE PROCEDURE V20251114140019__Create_netsuiteReceipt_main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='netsuite_create_receipt_mapping')) THEN 
CREATE TABLE `netsuite_create_receipt_mapping` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`netsuiteCustomerId` bigint not null,
    `academiaUserId` bigint not null,
    `academiaStudentCode` varchar(255) not null,
	`netsuiteReceiptId` bigint not null,
	`receiptHeaderId` bigint not null,
	`receiptNo` varchar(255) not null,
	`netsuiteInvoiceId` bigint not null,
    `billHeaderId` bigint not null,
	`billNo` varchar(255) not null,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    FOREIGN KEY (`netsuiteCustomerId`) REFERENCES `netsuite_create_customer_mapping`(`id`),
    FOREIGN KEY (`netsuiteInvoiceId`) REFERENCES `netsuite_create_invoice_mapping`(`id`),
    FOREIGN KEY (`academiaUserId`) REFERENCES `users`(`id`),
    FOREIGN KEY (`billHeaderId`) REFERENCES `bill_header`(`id`),
    FOREIGN KEY (`receiptHeaderId`) REFERENCES `receipt_header`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20251114140019__Create_netsuiteReceipt_main () $$ 
DROP PROCEDURE IF EXISTS V20251114140019__Create_netsuiteReceipt_main $$ 
DELIMITER ;