DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchCancelInvoiceToBePushed $$
CREATE PROCEDURE netsuiteFetchCancelInvoiceToBePushed()
BEGIN
# cancel invoice
SELECT 
    ncim.id AS netsuiteInvoiceMappingId,
	ncim.netsuiteCustomerId AS netsuiteCustomerId,
    ncim.netsuiteInvoiceId AS netsuiteInvoiceId,
	ncim.academiaUserId AS academiaUserId,
	ncim.academiaStudentCode as academiaStudentCode,
	ncim.billHeaderId as billHeaderId,
	ncim.billNo as billNo,
	ncim.isCancelled as isCancelled,
	ncim.isCreditNote as isCreditNote
FROM
    bill_header bh
    inner join netsuite_create_invoice_mapping ncim on bh.id=ncim.billHeaderId
    inner join netsuite_create_customer_mapping nccm on bh.studentId=nccm.academiaUserId  
    where bh.billStatus="CANCELLED" and bh.studentId is not null and ncim.isCancelled=false
#and bh.id in (63799,63800)
GROUP BY ncim.id
#limit 4
;
END $$
DELIMITER ;
