DELIMITER $$
DROP PROCEDURE IF EXISTS V20251211161242__Update_AppFeeHeadDetailDataProvider $$
CREATE PROCEDURE V20251211161242__Update_AppFeeHeadDetailDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_FEE_HEAD_DETAILS_INFO') THEN 
SET @dydtDataLineItemId=(select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_FEE_HEAD_DETAILS_INFO');
update dydt_data_line_item set sqlSelectQueryDef="SELECT
		fh.feeHeadName AS fee_head,
        fshd.feeAmount AS fps_total,
        COALESCE(aoi.financialAidGranted, 0) AS financial_aid,
        prog.programCode as programCode,
        prog.programName as programName,
        py.itemValue  as periodYear,
        pbpc.printName as periodName,
        pbpc.id as periodId,
        pbpc.programPeriodSeq as sequence,
	    fp.feePlanName as FeePlanName,
        fshd.feeHeadSequence AS feeHeadSequence
       FROM fee_stage_head_config fshd
     JOIN fee_plan_rule_stage fprs ON fshd.feePlanRuleStageId = fprs.id
     JOIN fee_stage_master fsm ON fsm.id = fprs.stageId and fsm.stageName = 'Course execution'
     JOIN fee_heads fh ON fshd.feeHeadId = fh.id AND fh.whetherDiscountFeeHead = 0
     JOIN fee_plan_rules fpr ON fprs.feePlanRuleId = fpr.id
     JOIN fee_plan fp ON fpr.feePlanId = fp.id AND fp.feePlanStatus = 'ACTIVE'
     JOIN fee_plan_type fpt ON fpt.id = fp.feePlanType AND fpt.feePlanType = 'Program'
     JOIN fee_plan_acad_locations apal ON fp.id = apal.feePlanId
	JOIN prog_batch_period_config pbpc on pbpc.id = apal.progBatchPeriodConfigId
    JOIN batches b ON pbpc.programBatchId = b.id
    JOIN programs prog on b.programId = prog.id
    LEFT JOIN period_year py on py.id = pbpc.periodYearId
    LEFT JOIN program_batch_students pbs ON pbs.programBatchId = b.id
    LEFT JOIN fee_plan_submission_sch fps ON fps.feeStageHeadConfigId = fshd.id
	JOIN application_program ap ON ap.programId = prog.id
	JOIN application aa ON aa.id = ap.applicationId
    LEFT JOIN applicant_person app ON app.id = aa.applicantPersonId
    LEFT JOIN applicant_other_information aoi ON aoi.applicantPersonId = app.id
    LEFT JOIN applicant_other_information_cd aoic ON aoic.applicantOtherInfoId = aoi.id",
    sqlWhereQueryDef = "WHERE ap.id = PRM_APPLICATION_PROGRAM_ID  GROUP BY fh.feeHeadName, pbpc.id, prog.programCode  order by pbpc.programPeriodSeq,fshd.feeHeadSequence"
    where id=@dydtDataLineItemId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251211161242__Update_AppFeeHeadDetailDataProvider () $$
DROP PROCEDURE IF EXISTS V20251211161242__Update_AppFeeHeadDetailDataProvider $$
DELIMITER ;