DELIMITER $$
DROP PROCEDURE IF EXISTS fatchInvoiceToBePushInXero $$
CREATE PROCEDURE fatchInvoiceToBePushInXero(jobLastRunTimestamp timestamp)
BEGIN
SELECT 
    FUNC_INC_VAR_SESSION_REC() AS id,
    xUser.xeroContactId AS xeroContactId,
	xUser.academiaUserId as academiaUserId,
    null as academiaSponsorId,
    bill.totalAmount AS unitAmount,
    bill.billNo AS invoiceNumber,
	bill.id AS billHeaderId,
    curr.currencyCode AS currencyCode,
    bill.billingDate AS billingDate,
    bill.dueDate AS dueDate,
    bill.reasonForManualBill AS reason,
    bill.billStatus AS billStatus,
    bill.academyLocationId AS academyLocationId,
    bill.cancellationDate AS cancellationDate,
    bill.cancellationNarration AS cancellationNarration,
    bill.raiseBillCategory AS raiseBillCategory,
    xeroInvMap.id as xeroInvDbId,
    CASE
    WHEN feeHeadMap.value IS NOT NULL THEN feeHeadMap.value
    ELSE prog.programNameLanguageThree
	END AS accountCode,
    xeroInvMap.createdDate as createdDate,
    null AS lineAmount,
    null AS feeHeadName, 
   -- GROUP_CONCAT(feeHead.feeHeadName SEPARATOR ',')  AS feeHeadName,
    prog.programName AS programCode,
    fp.feePlanName AS feePlanName,
    c.courseName AS courseName,
    c.courseCode AS courseCode,
    CASE
    WHEN fpr.feeRuleDesc IS NULL OR fpr.feeRuleDesc = '' THEN fp.feePlanName
    ELSE CONCAT(raiseBillType, '/', fpr.feeRuleDesc)
END AS reference
FROM
    xero_user_mapping AS xUser
        JOIN
    bill_header AS bill ON (bill.studentId = xUser.academiaUserId
        AND bill.raiseBillCategory = 'BILL_RECEIVABLE' AND bill.raiseBillType NOT IN ('SERVICE_PROVIDED','SERVICE_RECEIVED'))
	    INNER JOIN bill_fee_plan_rule_stage bfprs
        ON bfprs.billId = bill.id
    INNER JOIN fee_stage_head_config fshc
        ON fshc.id = bfprs.feeStageHeadConfigId
    INNER JOIN fee_plan_rule_stage fprs
       ON fshc.feePlanRuleStageId=fprs.id
    INNER JOIN fee_plan_rules fpr
        ON fpr.id = fprs.feePlanRuleId
    INNER JOIN fee_plan fp ON
    fp.id = fpr.feePlanId
    JOIN
	prog_batch_seat_config As pbsc on pbsc.id=bill.programBatchSeatConfigId
		join 
	batches as batch on batch.id=pbsc.programBatchId
       join 
	programs as prog on prog.id= batch.programId
        LEFT JOIN
    currency AS curr ON bill.currencyId = curr.id
        LEFT JOIN
    xero_invoice_mapping AS xeroInvMap ON (xeroInvMap.academiaBillHeaderId = bill.id and bill.academyLocationId =xeroInvMap.academyLocationId)
		LEFT JOIN
    drop_down AS drp ON (drp.type = 'XeroRetriggerMaxAttemptDays')
    LEFT JOIN student_course_enrollment sce on sce.admissionId = bill.admissionId
    LEFT JOIN courses c on c.id = sce.courseVarientId
    
    LEFT JOIN bill_fee_plan_rule_stage AS bfs 
        ON bfs.billId = bill.id

	LEFT JOIN fee_stage_head_config AS fshc2
        ON fshc2.id = bfs.feeStageHeadConfigId

	LEFT JOIN fee_heads AS feeHead 
        ON feeHead.id = fshc2.feeHeadId

	LEFT JOIN drop_down AS feeHeadMap
        ON feeHeadMap.type = 'xeroFeeHead'
       AND feeHeadMap.name = feeHead.feeHeadName
WHERE
    bill.totalAmount IS NOT NULL AND (xeroInvMap.id IS NULL  OR (xeroInvMap.error IS NOT NULL
        AND (xeroInvMap.createdDate + INTERVAL CAST(drp.value AS SIGNED) DAY)>=CURRENT_DATE))
        group by bill.id;    
END $$
DELIMITER ;