DELIMITER $$
DROP PROCEDURE IF EXISTS V20251216113416__Update_SportsClubMsgTemplate $$
CREATE PROCEDURE V20251216113416__Update_SportsClubMsgTemplate()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT id      FROM msg_template_config      WHERE code = 'Buzz Sports Club Membership Request')) THEN 
SET @msgTemplateConfigId := (
    SELECT id 
    FROM msg_template_config 
    WHERE code = 'Buzz Sports Club Membership Request'
);

-- Update subject
UPDATE msg_template 
SET subjectLine = 'Welcome and thank you for registering for the Sports Club!'
WHERE msgTemplateConfigId = @msgTemplateConfigId;

-- Update message content
UPDATE msg_template 
SET msgContent = '
<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse;">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px; font-family:arial,helvetica,sans-serif; font-size:12px; color:#000;">

				<p><strong>Welcome and thank you for registering for the Sports Club!</strong></p>

				<p>
					The annual non-refundable sports club fee (R350) will be charged directly to your student account.
					Clubs that require additional membership fees will be advised on the Information Sheet per Sports Club
					and payable at a later stage. Some clubs will require additional membership fees which is payable at a later stage.
					These additional fees include national federation affiliation, kit etc. and can be paid to the sports club directly.
				</p>

				<p>
					Please note the annual Sports Club fee includes a limited-edition Sports Club T-shirt which you can collect during Sports Week.
				</p>

				<p>
					Please ensure you click on the WhatsApp links below to be added to your respective Sports Clubs groups.
					This will ensure you''re kept up to date with all latest developments, find out who your Club Administrator is
					and get all the information relating to the sports club that you have registered for!
				</p>

				<hr />

				<p><strong>Netball – Competitive &amp; Social</strong><br />
					<a href="https://chat.whatsapp.com/K2DTpNH5znNCuEOybJoL4U" target="_blank">VCCT NETBALL - 2024</a>
				</p>

				<p><strong>Cricket (Men) – Competitive</strong><br />
					<a href="https://chat.whatsapp.com/F8UfQMm8SOG9YkPXt9cbKg" target="_blank">VCCT CRICKET - 2024 🏏</a>
				</p>

				<p><strong>Cricket (Ladies) – Social</strong><br />
					<a href="https://chat.whatsapp.com/FHJC0b87C1KFytI2ng0Jq6" target="_blank">VCCT LADIES CRICKET - 2024</a>
				</p>

				<p><strong>Football (Men) – Competitive &amp; Social</strong><br />
					<a href="https://chat.whatsapp.com/HmOHLnV6btvBetop0V7sGS" target="_blank">VCCT FOOTBALL - 2024</a>
				</p>

				<p><strong>Football (Ladies) – Social</strong><br />
					<a href="https://chat.whatsapp.com/Df6b1oauamp51b5QEQ2Jmx" target="_blank">VCCT LADIES FOOTBALL - 2024</a>
				</p>

				<p><strong>Touch Rugby – Competitive</strong><br />
					<a href="https://chat.whatsapp.com/JqTlzVN2eWg9cxL8EydVdk" target="_blank">VCCT TOUCH RUGBY - 2024</a>
				</p>

				<p><strong>Indoor Hockey (Men &amp; Ladies)</strong><br />
					<a href="https://chat.whatsapp.com/HVvYdTjyVbLKI4Nwx6UQHR" target="_blank">VCCT INDOOR HOCKEY - 2024</a>
				</p>

				<p><strong>Golf – Beginners &amp; Advanced</strong><br />
					<a href="https://chat.whatsapp.com/H6YGD1SIxqw4TBeudXEdQi" target="_blank">VCCT GOLF - 2024</a>
				</p>

				<p><strong>Canoeing – Beginners &amp; Advanced</strong><br />
					<a href="https://chat.whatsapp.com/LlBqxZNllCkJzciSmSRM0Q" target="_blank">VCCT CANOEING / SURFSKI - 2024</a>
				</p>

				<p><strong>Surfing – Beginners &amp; Advanced</strong><br />
					<a href="https://chat.whatsapp.com/E3V85LEoBQM9yc0V9ZQjbq" target="_blank">VCCT SURFING - 2024</a>
				</p>

				<p><strong>Cycling – Beginners &amp; Advanced</strong><br />
					<a href="https://chat.whatsapp.com/K4Ys8iukorL0BB2hbjRXo8" target="_blank">VCCT CYCLING - 2024</a>
				</p>

				<hr />

				<p><strong>POPIA Disclaimer:</strong><br />
					As a registered member of the Sports Club you have automatically given consent to being added to each sports club WhatsApp group
					and to your personal information (your cell phone number and name) being noticeable to any person in each group.
					All members of the WhatsApp groups may not make use of such personal information for whatsoever reason,
					without obtaining the consent of the relevant person.
				</p>

				<p>
					Please also be advised that as a member of the Sports Club you consent to any photos taken during a sporting activity
					offered by the Sports Club being shared on the official social media pages, media releases and at the sole discretion
					of IIE''s Varsity College.
				</p>

				<p>
					For more information on the Sports Club and what each sports club offers on campus,
					please speak to your campus Sports Coordinator or your Sports Club Administrator in charge of each Sports Club.
				</p>

			</td>
		</tr>
	</tbody>
</table>
</body>
</html>
'
WHERE msgTemplateConfigId = @msgTemplateConfigId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251216113416__Update_SportsClubMsgTemplate () $$
DROP PROCEDURE IF EXISTS V20251216113416__Update_SportsClubMsgTemplate $$
DELIMITER ;