DELIMITER $$
DROP PROCEDURE IF EXISTS V20251226102225__Create_privysealmapping_main $$
CREATE PROCEDURE V20251226102225__Create_privysealmapping_main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='privyseal_certificate_mapping')) THEN 
CREATE TABLE `privyseal_certificate_mapping` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`privysealId` varchar(255) not null,
    `credentialId` varchar(255) not null,
    `certificateNumber` varchar(255) not null,
	`isEligible` boolean null default b'1',
	`studentId` bigint not null,
	`studentCode` varchar(255) null,
	`studentPrintName` varchar(255) null,
    `programCompletionDetailId` bigint not null,
    `studentAcademicTopicId` bigint not null,
	`certificatePdfUrl` text null,
    `certificateImageUrl` text null,
    `certificateqrCodeUrl` text null,
    `certificateSealUrl` text null,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    FOREIGN KEY (`programCompletionDetailId`) REFERENCES `program_completion_details`(`id`),
    FOREIGN KEY (`studentAcademicTopicId`) REFERENCES `student_academic_topics`(`id`),
    FOREIGN KEY (`studentId`) REFERENCES `users`(`id`)
) ENGINE=InnoDB;
END IF;  

END $$
CALL V20251226102225__Create_privysealmapping_main () $$ 
DROP PROCEDURE IF EXISTS V20251226102225__Create_privysealmapping_main $$ 
DELIMITER ;