DELIMITER $$
DROP PROCEDURE IF EXISTS V20251229184547__Update_UpdateOfferLetterTransCreditData $$
CREATE PROCEDURE V20251229184547__Update_UpdateOfferLetterTransCreditData()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_PROGRAM_ID')) THEN 
SET @dydtDataLineItemId=(select MAX(id) from `dydt_data_line_item` where dataSourceCode='APPLICATION_INFO' and whereClauseBindingDef='PRM_APPLICATION_PROGRAM_ID');
update dydt_data_line_item set sqlSelectQueryDef="SELECT 
        p.programCode AS program_code,
        p.programName AS program_name,
        p.programNameToBePrint AS program_print_name,
        p.programNameToBePrintLanguageOne AS program_print_name_afr,
        pd.shortCode AS primary_dept_code,
        pd.deptName AS primary_dept_name,
        psd.shortCode AS secondary_dept_code,
        psd.deptName AS secondary_dept_name,
        b.batchName AS batch_name,
        b.startDate AS batch_start_date,
        b.tillDate AS batch_tilldate,
        pg.groupName AS program_group_name,
        DATE_FORMAT(aprgm.schoolAttendanceStartDate,'%d-%m-%Y') AS school_attendance_start_date,
        pod.programMaxDurationTime AS program_Max_Duration_Time,
        pod.programNQFcreditsWILEL AS program_NQF_credits_WILEL,
        md.itemValue as mode_of_delivery,
		DATE(atcc.expectedCompletionDate) AS Expected_Completion_Date,
        atcc.exemptedCredit AS Exempted_Credit,
        atcc.programDuration as Program_Duration,
        GROUP_CONCAT(DISTINCT c_repeat.courseCode
        ORDER BY c.courseCode
        SEPARATOR ', ') AS Repeat_Course_Code,
        GROUP_CONCAT(DISTINCT c.courseCode
        ORDER BY c.courseCode
        SEPARATOR ', ') AS Course_Code
    FROM
        application_program aprgm
        INNER JOIN
    application a ON a.id = aprgm.applicationId
            LEFT JOIN
        programs p ON aprgm.programId = p.id
            LEFT JOIN
         program_other_details pod ON p.id = pod.programId
            LEFT JOIN
        prog_batch_seat_config pbsc ON aprgm.progBatchSeatConfigId = pbsc.id
            LEFT JOIN
        batches b ON b.id = pbsc.programBatchId
            LEFT JOIN
        mode_of_delivery md ON b.modeOfDeliveryId = md.id
            LEFT JOIN
        department pd ON pd.id = p.programDepartmentId
            LEFT JOIN
        department psd ON psd.id = p.subDepartmentId
    		LEFT JOIN
       program_group pg ON pg.id = p.programGroupId
       LEFT JOIN
        applicant_transfer_credit_request atcr ON atcr.applicantId = a.id
        AND atcr.programId = p.id
        AND atcr.programBatchId = b.id
        LEFT JOIN
    applicant_transfer_credit_completion atcc ON atcc.applicantId = a.id
        AND atcc.programId = p.id
        AND atcc.programBatchId = b.id
        LEFT JOIN
    courses c_repeat ON c_repeat.id = atcr.courseId
        AND atcr.TransferCreditStatus = 'REPEAT'
        LEFT JOIN
    courses c ON c.id = atcr.courseId and atcr.status='APPROVE'",
resultColumnsDef = "program_code,program_name,program_print_name,program_print_name_afr,primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,program_group_name,school_attendance_start_date,
program_Max_Duration_Time,program_NQF_credits_WILEL,mode_of_delivery,Program_Duration,Exempted_Credit,Expected_Completion_Date,Course_Code,Repeat_Course_Code"
where id=@dydtDataLineItemId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251229184547__Update_UpdateOfferLetterTransCreditData () $$
DROP PROCEDURE IF EXISTS V20251229184547__Update_UpdateOfferLetterTransCreditData $$
DELIMITER ;