DELIMITER $$
DROP PROCEDURE IF EXISTS V20251231140756__Create_Sibling_Ranking_CSM $$
CREATE PROCEDURE V20251231140756__Create_Sibling_Ranking_CSM()
BEGIN

IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='sibling_ranking')) THEN 
CREATE TABLE `sibling_ranking` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`code` VARCHAR(255) NOT NULL,
	`value` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'sibling_ranking')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'sibling_ranking','SIBLING_RANKING','Fees & Payments','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

IF  EXISTS ((select * from standard_master where tableName = 'sibling_ranking')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'sibling_ranking');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF; 

-- TRANSLATION

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'SIBLING_RANKING')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'SIBLING_RANKING', 'SIBLING_RANKING', 'sibling ranking','broer of suster rangorde','xếp hạng anh chị em',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'CODE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'CODE', 'code', 'code','kode','Tổ chức tài chính',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'VALUE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'VALUE', 'VALUE', 'value','waarde','giá trị',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='TRANSLATIONS' AND keyName='BILL_PAYMENT_IS_NOT_ALLOWED_FOR_INVOICES_WITH_MULTIPLE_COST_CENTERS')) THEN
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage)
VALUES ('TRANSLATIONS', 'BILL_PAYMENT_IS_NOT_ALLOWED_FOR_INVOICES_WITH_MULTIPLE_COST_CENTERS', 'Bill payment is not allowed for invoices with multiple cost centers', 'Bill payment is not allowed for invoices with multiple cost centers', 'Rekeningbetaling word nie toegelaat vir fakture met verskeie kostesentrums nie', 'Không được phép thanh toán hóa đơn đối với các hóa đơn có nhiều trung tâm chi phí');
END IF;

END $$
CALL V20251231140756__Create_Sibling_Ranking_CSM () $$ 
DROP PROCEDURE IF EXISTS V20251231140756__Create_Sibling_Ranking_CSM $$ 
DELIMITER ;