DELIMITER $$
DROP PROCEDURE IF EXISTS V20251231160300__Insert_HostelBedConfigLoader $$
CREATE PROCEDURE V20251231160300__Insert_HostelBedConfigLoader()
BEGIN

IF EXISTS ((SELECT id FROM import_utility_master where code='hostelbed')) THEN
 
	SET @importUtilityMasterId=(SELECT id FROM import_utility_master where code='hostelbed');
    
	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='HOSTEL' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
		VALUES ('HOSTEL', 'Hostel', 'Hostel', 1 , now(), '1', 1, 1, @importUtilityMasterId, 1); 
	END IF; 
		
	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BUILDING' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`)
		VALUES ('BUILDING', 'Building', 'Building', 1 , now(), '1', 1, 1, @importUtilityMasterId, 1); 
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FLOOR' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
		VALUES ('FLOOR', 'Floor', 'Floor', 1 , now(), '1', 1, 1, @importUtilityMasterId, 1);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ROOM' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`)
		VALUES ('ROOM', 'Room', 'Room', 1 , now(), '1', 1, 1, @importUtilityMasterId, 1);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ROOM_TYPE' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
		VALUES ('ROOM_TYPE', 'Room Type', 'Room Type', 1 , now(), '1', 1, 1, @importUtilityMasterId, 1);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BED_NO' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
		VALUES ('BED_NO', 'Bed No.', 'Bed No.', 1 , now(), '1', 1, 1, @importUtilityMasterId, 1);
	END IF; 


	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BED_DESCRIPTION' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
		VALUES ('BED_DESCRIPTION', 'Bed Description', 'Bed Description', 1 , now(), '1', 0, 0, @importUtilityMasterId, 1);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ACADEMY_LOCATION_ID' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
		VALUES ('ACADEMY_LOCATION_ID', 'AcademyLocationId', 'AcademyLocationId', 1 , now(), '1', 1, 0, @importUtilityMasterId, 0);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='STATUS' and isSchool = 1)) THEN 
		INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
		VALUES ('STATUS', 'Status', 'Status', 1 , now(), '1', 0, 0, @importUtilityMasterId, 0);
	END IF; 
    
    -- For College
    
    IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='HOSTEL' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
	VALUES ('HOSTEL', 'Hostel', 'Hostel', 0 , now(), '1', 1, 1, @importUtilityMasterId, 1); 
END IF; 
    
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BUILDING' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`)
	VALUES ('BUILDING', 'Building', 'Building', 0 , now(), '1', 1, 1, @importUtilityMasterId, 1); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FLOOR' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
	VALUES ('FLOOR', 'Floor', 'Floor', 0 , now(), '1', 1, 1, @importUtilityMasterId, 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ROOM' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`)
	VALUES ('ROOM', 'Room', 'Room', 0 , now(), '1', 1, 1, @importUtilityMasterId, 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ROOM_TYPE' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
	VALUES ('ROOM_TYPE', 'Room Type', 'Room Type', 0 , now(), '1', 1, 1, @importUtilityMasterId, 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BED_NO' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
	VALUES ('BED_NO', 'Bed No.', 'Bed No.', 0 , now(), '1', 1, 1, @importUtilityMasterId, 1);
END IF; 


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='BED_DESCRIPTION' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
	VALUES ('BED_DESCRIPTION', 'Bed Description', 'Bed Description', 0 , now(), '1', 0, 0, @importUtilityMasterId, 1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ACADEMY_LOCATION_ID' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
	VALUES ('ACADEMY_LOCATION_ID', 'AcademyLocationId', 'AcademyLocationId', 0 , now(), '1', 1, 0, @importUtilityMasterId, 0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='STATUS' and isSchool = 0)) THEN 
	INSERT INTO `loader_header` (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`) 
	VALUES ('STATUS', 'Status', 'Status', 0 , now(), '1', 0, 0, @importUtilityMasterId, 0);
END IF; 
 
END IF; 

END $$
CALL V20251231160300__Insert_HostelBedConfigLoader() $$
DROP PROCEDURE IF EXISTS V20251231160300__Insert_HostelBedConfigLoader $$
DELIMITER ;