DELIMITER $$
DROP PROCEDURE IF EXISTS V20260109114228__Update_BlackBoardUserCreationNoti $$
CREATE PROCEDURE V20260109114228__Update_BlackBoardUserCreationNoti()
BEGIN
SET SQL_SAFE_UPDATES=0;
Set @dataProviderId= (select id from dtprovider where dataProviderName='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS');
IF EXISTS ((select id from sql_dtprovider where dataProviderId=@dataProviderId)) THEN 
UPDATE `sql_dtprovider` SET `sqlQuery` = 'select\nT1.id AS ID,LOWER(\n    CONCAT(\n        LEFT(T1.lastName, 1), \'.\',\n        T1.firstName,\n        RIGHT(T1.code, 3),\n        \'#\'\n) \n)AS std_blackboard_pwr,\n T1.code as STUDENT_CODE,\nT1.printName as PRINT_NAME,\nT1.firstName as FIRST_NAME,\nT1.lastName as LAST_NAME,\nT5.displayName as ACADEMY_LOCATION_NAME,\nT4.code as ADMISSION_ID,\nT3.emailId as EMAIL_ID,\nT8.programNameToBePrint as PROGRAM_PRINT_NAME,\nT7.batchName as BATCH,\nT9.programPeriodName as PERIOD,\nconcat(T14.countryName,\', \',T13.countryRegionName,\', \',T12.cityName,\', \',T11.pincode,\', \',T11.phoneNo,\', \',T11.cellNo,\', \',T11.primaryeEmailId) as STUDENT_ADDRESS,\nT3.alternateEmailId as ALTERNATE_EMAIL_ID,\nconcat(T3.mobileCountryCode,\'\',T3.mobileNumber) as MOBILE_NO,\nT16.orgName as ORGANIZATION_NAME,\nconcat(T20.countryName,\', \',T21.countryRegionName,\', \',T19.cityName,\', \',T18.pincode,\', \',T18.phoneNo,\', \',T18.cellNo,\', \',T18.primaryeEmailId) as ORGANIZATION_ADDRESS,\nT5.locationName as ACADEMY_LOCATION,\n(Case \n    when T5.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, \'/\', \'emailer/images/logo_default_image.png\') \n    when T5.logoUrl is null and org.orgUrl is null then \'https://www.serosoft.com/mailer/academiaerp_logo_red.png\'\n    else CONCAT(org.orgUrl, \'/\', T5.logoUrl)end) as LOGO_URL,\n    (Case when T5.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, \'/\', T5.headerUrl) \n    else NULL end) as HEADER_URL,\n        (Case when T5.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, \'/\', T5.footerUrl) \n    else NULL end) as FOOTER_URL \nfrom users as T1\ninner join students as T2 on T2.userId=T1.id\nleft join persons as T3 on T3.id=T2.personId\nleft join admission as T4 on T4.studentId=T2.userId\nleft join academy_location as T5 on T5.id=T4.academyLocationId\nleft join program_batch_students T6 ON T6.admissionId = T5.id\nLEFT JOIN batches T7 ON T7.id = T6.programBatchId\nLEFT JOIN programs T8 ON T8.id = T7.programId\nLEFT JOIN prog_batch_period_config T9 ON T9.id = T6.progBatchPeriodConfigId\nLEFT JOIN academy_location_addresses T10 ON T10.academyLocationId = T4.academyLocationId\nLEFT JOIN address T11 ON T11.id = T10.addressId AND T11.addressTypeId = 5\nleft join city T12 on T12.id=T11.cityId\nleft join country_region T13 on T13.id=T12.countryRegionId\nleft join country T14 on T14.id=T12.countryId\nleft join locations T15 on T14.id=T5.locationId\nleft join organizations T16 on T16.id=T15.organizationId\nleft join location_addresses T17 on T17.locationId=T15.id\nleft join address T18 on T18.id=T17.addressId and T18.addressTypeId = 3\nleft join city T19 on T19.id=T18.cityId\nleft join country T20 on T20.id=T18.countryId\nleft join country_region T21 on T21.id=T18.countryRegionId\nleft join organizations org on org.id = 1\nwhere T1.id IN (namedParams) limit 1', `jsonString` = '{\n    \"id\": 1,\n    \"searchResultViewColumns\": [\n        {\n            \"id\": 1,\n            \"value\": \"code\",\n            \"resultKey\": \"STUDENT_CODE\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 0\n        },{ \n            \"id\": 2,\n            \"value\": \"printName\",\n            \"resultKey\": \"PRINT_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 1\n        },{\n            \"id\": 3,\n            \"value\": \"firstName\",\n            \"resultKey\": \"FIRST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 2\n        },\n        {\n            \"id\": 4,\n            \"value\": \"lastName\",\n            \"resultKey\": \"LAST_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 3\n        },\n        {\n            \"id\": 5,\n            \"value\": \"displayName\",\n            \"resultKey\": \"ACADEMY_LOCATION_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 4\n        },\n        {\n            \"id\": 6,\n            \"value\": \"code\",\n            \"resultKey\": \"ADMISSION_ID\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 5\n        },\n        {\n            \"id\": 7,\n            \"value\": \"emailId\",\n            \"resultKey\": \"EMAIL_ID\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 6\n        },       \n        {\n            \"id\": 8,\n            \"value\": \"programNameToBePrint\",\n            \"resultKey\": \"PROGRAM_PRINT_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 7\n        },\n        {\n            \"id\": 9,\n            \"value\": \"batchName\",\n            \"resultKey\": \"BATCH\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 8\n        },\n        {\n            \"id\": 10,\n            \"value\": \"programPeriodName\",\n            \"resultKey\": \"PERIODE\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 9\n        },\n        {\n            \"id\": 11,\n            \"value\": \"student address\",\n            \"resultKey\": \"STUDENT_ADDRESS\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 10\n        },\n        {\n            \"id\": 12,\n            \"value\": \"alternateEmailId\",\n            \"resultKey\": \"ALTERNATE_EMAIL_ID\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 11\n        },\n        {\n            \"id\": 13,\n            \"value\": \"mobile number\",\n            \"resultKey\": \"MOBILE_NO\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 12\n        },       \n        {\n            \"id\": 14,\n            \"value\": \"orgName\",\n            \"resultKey\": \"ORGANIZATION_NAME\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 13\n        },\n        {\n            \"id\": 15,\n            \"value\": \"organization address\",\n            \"resultKey\": \"ORGANIZATION_ADDRESS\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 14\n        },\n{\n            \"id\": 16,\n            \"value\": \"locationName\",\n            \"resultKey\": \"ACADEMY_LOCATION\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 15\n        },\n        {\n            \"id\": 17,\n            \"value\": \"logoUrl\",\n            \"resultKey\": \"LOGO_URL\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 16\n        },\n        {\n            \"id\": 18,\n            \"value\": \"headerUrl\",\n            \"resultKey\": \"HEADER_URL\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 17\n        },\n        {\n            \"id\": 19,\n            \"value\": \"footerUrl\",\n            \"resultKey\": \"FOOTER_URL\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 18\n        } ,{\n   \"id\": 20, \n            \"value\": \"std_blackboard_pwr\",\n            \"resultKey\": \"std_blackboard_pwr\",\n            \"displayCode\": \"\",\n            \"displayOrder\": 19\n}   ]\n}' WHERE dataProviderId =@dataProviderId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20260109114228__Update_BlackBoardUserCreationNoti () $$
DROP PROCEDURE IF EXISTS V20260109114228__Update_BlackBoardUserCreationNoti $$
DELIMITER ;