DELIMITER $$
DROP PROCEDURE IF EXISTS V20260116185538__Insert_Stenden_Student_Id_Card $$
CREATE PROCEDURE V20260116185538__Insert_Stenden_Student_Id_Card()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'STENDEN_STUDENT_ID_CARD')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('7', 'STENDEN_STUDENT_ID_CARD', 'Stenden Student Id Card', 'STENDEN_STUDENT_ID_CARD.png', 'CommonReport_STENDEN_STUDENT_ID_CARD.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'STENDEN_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='STENDEN_STUDENT_ID_CARD'))) THEN

	set @studentIDCard = (select id from report_template where templateCode ='STENDEN_STUDENT_ID_CARD');
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@studentIDCard, 'TRANS_STUDENT_ID_NUMBER', 'Student Number', '1', NOW()),
	(@studentIDCard, 'TRANS_CODE', 'Code', '1', NOW()),
	(@studentIDCard, 'TRANS_EMERGENCY_NUMBERS', 'Emergency Numbers', '1', NOW()),
    
    (@studentIDCard, 'TRANS_STENDEN_SECURITY', 'Stenden Security', '1', NOW()),
	(@studentIDCard, 'TRANS_STENDEN_SECURITY_VALUE', '0716194863', '1', NOW()),
   
     
    (@studentIDCard, 'TRANS_MULTI_SECURITY', 'Multi Security', '1', NOW()),
    (@studentIDCard, 'TRANS_MULTI_SECURITY_VALUE', '046-6242508', '1', NOW()),
    
    (@studentIDCard, 'TRANS_GARDMED_AMBULANCE_SERVICE', 'Gardmed Ambulance Service', '1', NOW()),
    (@studentIDCard, 'TRANS_GARDMED_AMBULANCE_SERVICE_VALUE', '0827592134', '1', NOW());
    
  END IF;

END $$
CALL V20260116185538__Insert_Stenden_Student_Id_Card() $$
DROP PROCEDURE IF EXISTS V20260116185538__Insert_Stenden_Student_Id_Card $$
DELIMITER ;