DELIMITER $$
DROP PROCEDURE IF EXISTS V20260120154431__Alter_ExamBlock_AddColumns $$
CREATE PROCEDURE V20260120154431__Alter_ExamBlock_AddColumns()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='exam_block' AND column_name='courseWiseFeesApplicable')) THEN 
ALTER TABLE `exam_block` 
ADD COLUMN `courseWiseFeesApplicable` BIT(1) NOT NULL DEFAULT b'0' AFTER `status`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='exam_block' AND column_name='isAmenitiesApplicable')) THEN 
ALTER TABLE `exam_block` 
ADD COLUMN `isAmenitiesApplicable` BIT(1) NOT NULL DEFAULT b'0' AFTER `courseWiseFeesApplicable`;
END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='exam_block' and column_name='onlineExamApplicable')) THEN 
ALTER TABLE `exam_block`
DROP COLUMN `onlineExamApplicable`;
END IF;

    IF EXISTS (
        SELECT 1
        FROM information_schema.COLUMNS
        WHERE table_schema = DATABASE()
          AND table_name = 'exam_block'
          AND column_name = 'examCenterId'
    ) THEN

        -- Drop foreign key
        IF EXISTS (
            SELECT 1
            FROM information_schema.KEY_COLUMN_USAGE
            WHERE table_schema = DATABASE()
              AND table_name = 'exam_block'
              AND constraint_name = 'exam_block_exam_center_fk'
        ) THEN
            ALTER TABLE exam_block
            DROP FOREIGN KEY exam_block_exam_center_fk;
        END IF;

        -- Drop index
        IF EXISTS (
            SELECT 1
            FROM information_schema.STATISTICS
            WHERE table_schema = DATABASE()
              AND table_name = 'exam_block'
              AND index_name = 'idx_exam_block_examCenterId'
        ) THEN
            ALTER TABLE exam_block
            DROP INDEX idx_exam_block_examCenterId;
        END IF;

        -- Drop column
        ALTER TABLE exam_block
        DROP COLUMN examCenterId;

    END IF;

END $$
CALL V20260120154431__Alter_ExamBlock_AddColumns() $$
DROP PROCEDURE IF EXISTS V20260120154431__Alter_ExamBlock_AddColumns $$
DELIMITER ;