CREATE TABLE `leave_report` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `programId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) NOT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `dateOfAbsence` date NOT NULL,
  `attendanceType` varchar(35) NOT NULL,
  `fromTime` datetime DEFAULT NULL,
  `toTime` datetime DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `leaveStatus` varchar(45) NOT NULL,
  `leaveApprovalDate` date DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_leave_report_1_idx` (`programId`),
  KEY `fk_leave_report_batchId_idx` (`batchId`),
  KEY `fk_leave_report_periodId_idx` (`periodId`),
  KEY `fk_leave_report_courseId_idx` (`courseId`),
  KEY `fk_leave_report_facultyId_idx` (`facultyId`),
  KEY `fk_leave_report_admissionId_idx` (`admissionId`),
  KEY `fk_leave_report_sectionId_idx` (`sectionId`),
  KEY `fk_leave_report_lastUpdate_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_leave_report_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_leave_report_courseId` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_leave_report_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_leave_report_programid` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_leave_report_admissionId` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_leave_report_facultyId` FOREIGN KEY (`facultyId`) REFERENCES `faculties` (`personId`),
  CONSTRAINT `fk_leave_report_lastUpdate` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_leave_report_sectionId` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;