CREATE TABLE `calendar_slots` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'This table stores periods on each working day of each calendar',
  `calendarId` bigint(20) NOT NULL,
  `weekday` varchar(10) NOT NULL,
  `startTime` datetime NOT NULL,
  `endTime` datetime NOT NULL,
  `period` int(11) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_calendar_slots_2_idx` (`lastUpdatedBy`),
  KEY `fk_calendar_slots_1_idx` (`calendarId`),
  CONSTRAINT `fk_calendar_slots_1` FOREIGN KEY (`calendarId`) REFERENCES `calendars` (`id`),
  CONSTRAINT `fk_calendar_slots_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

CREATE TABLE `master_time_table` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `calendarSlotId` bigint(20) NOT NULL,
  `courseVariantId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL COMMENT 'This table stores time slot & variant association.',
  PRIMARY KEY (`id`),
  KEY `fk_master_time_table_1_idx` (`calendarSlotId`),
  KEY `fk_master_time_table_2_idx` (`courseVariantId`),
  KEY `fk_master_time_table_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_master_time_table_1` FOREIGN KEY (`calendarSlotId`) REFERENCES `calendar_slots` (`id`),
  CONSTRAINT `fk_master_time_table_2` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `fk_master_time_table_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);
