CREATE TABLE `application_fee_plan_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicationFeeDetailId` bigint(20) DEFAULT NULL,
  `applicationProgramId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refapplicationfeedetail878_idx` (`applicationFeeDetailId`),
  KEY `Refapplicationprogram767_idx` (`applicationProgramId`),
  KEY `Reffeeplan7673_idx` (`feePlanId`),
  KEY `Reflastupdateby6567_idx` (`lastUpdatedBy`),
  CONSTRAINT `Reflastupdateby6567` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refapplicationfeedetail878` FOREIGN KEY (`applicationFeeDetailId`) REFERENCES `application_fee_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refapplicationprogram767` FOREIGN KEY (`applicationProgramId`) REFERENCES `application_program` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reffeeplan7673` FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



ALTER TABLE `application_fee_details`
DROP FOREIGN KEY `Reffeeplan`,
DROP FOREIGN KEY `Refapplicationprogram76`;
ALTER TABLE `application_fee_details`
DROP COLUMN `feePlanId`,
DROP COLUMN `applicationProgramId`,
DROP INDEX `Reffeeplan_idx` ,
DROP INDEX `Refapplicationprogram76_idx` ;

ALTER TABLE `application_fee_plan_details` 
ADD COLUMN `feeStageHeadConfigId` BIGINT(20) NULL DEFAULT NULL AFTER `feePlanId`,
ADD COLUMN `feeHeadAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `feeStageHeadConfigId`,
ADD INDEX `RefFeeStageHeadConfigId3452_idx` (`feeStageHeadConfigId` ASC);
ALTER TABLE `application_fee_plan_details` 
ADD CONSTRAINT `RefFeeStageHeadConfigId3452`
  FOREIGN KEY (`feeStageHeadConfigId`)
  REFERENCES `fee_stage_head_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `fee_plan` 
ADD COLUMN `applicableFor` VARCHAR(100) NULL DEFAULT NULL AFTER `whetherServiceReceivable`;
