CREATE TABLE `enq_assignment_hours` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `workingFromTime` time NOT NULL,
  `workingToTime` time NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unq_enq_assignment_hours_academylocationid` (`academyLocationId`),
  KEY `fk_enq_assignment_hours_userid_idx` (`lastUpdatedBy`),
  KEY `fk_enq_assignment_hours_academyid_idx` (`academyLocationId`),
  CONSTRAINT `fk_enq_assignment_hours_academyid` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_enq_assignment_hours_userid` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;