SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE `exam_passed`(  
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `itemValue` VARCHAR(255) NOT NULL,
  `itemCode` VARCHAR(255) NOT NULL,
  `lastUpdate` TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_exam_passed_users` (`lastUpdatedBy`),
  CONSTRAINT `fk_exam_passed_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);

ALTER TABLE `education_histories`   
  DROP COLUMN `examName`;

ALTER TABLE `education_histories`   
  ADD COLUMN `examPassedId` BIGINT(20) NOT NULL AFTER `personId`,
   ADD  INDEX `fk_education_histories_exam_passed` (`examPassedId`),
  ADD CONSTRAINT `fk_education_histories_exam_passed` FOREIGN KEY (`examPassedId`) REFERENCES `exam_passed`(`id`);
 
 
 SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`whetherChild`,`whetherParent`,`droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) VALUES (@standardMasterMaxId+1,NULL,'exam_passed','EXAM_PASSED','\0','\0',NULL,1,@currentTimeStamp);


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`,`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`) VALUES (@ItemsMaxId+1,'code','ITEM_CODE',@standardMasterMaxId+1,'varchar',1,'\0',NULL,NULL,NULL,'\0','\0','\0',1,@currentTimeStamp);
INSERT INTO `standard_master_items`(`id`,`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`) VALUES (@ItemsMaxId+2,'value','ITEM_VALUE',@standardMasterMaxId+1,'varchar',1,'\0',NULL,NULL,NULL,'\0','\0','\0',1,@currentTimeStamp);

SET FOREIGN_KEY_CHECKS=1; 