/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.scanner.classpath;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.FeatureDetector;
import com.googlecode.flyway.core.util.Resource;
import com.googlecode.flyway.core.util.UrlUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import com.googlecode.flyway.core.util.scanner.classpath.ClassPathLocationScanner;
import com.googlecode.flyway.core.util.scanner.classpath.DefaultUrlResolver;
import com.googlecode.flyway.core.util.scanner.classpath.FileSystemClassPathLocationScanner;
import com.googlecode.flyway.core.util.scanner.classpath.JarFileClassPathLocationScanner;
import com.googlecode.flyway.core.util.scanner.classpath.OsgiClassPathLocationScanner;
import com.googlecode.flyway.core.util.scanner.classpath.UrlResolver;
import com.googlecode.flyway.core.util.scanner.classpath.jboss.JBossVFSv2UrlResolver;
import com.googlecode.flyway.core.util.scanner.classpath.jboss.JBossVFSv3ClassPathLocationScanner;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);

    public Resource[] scanForResources(String path, String prefix, String suffix) throws IOException {
        LOG.debug("Scanning for classpath resources at '" + path + "' (Prefix: '" + prefix + "', Suffix: '" + suffix + "')");
        TreeSet<ClassPathResource> resources = new TreeSet<ClassPathResource>();
        Set<String> resourceNames = this.findResourceNames(path, prefix, suffix);
        for (String resourceName : resourceNames) {
            resources.add(new ClassPathResource(resourceName));
            LOG.debug("Found resource: " + resourceName);
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public Class<?>[] scanForClasses(String location, Class<?> implementedInterface) throws Exception {
        LOG.debug("Scanning for classes at '" + location + "' (Implementing: '" + implementedInterface.getName() + "')");
        ArrayList classes = new ArrayList();
        Set<String> resourceNames = this.findResourceNames(location, "", ".class");
        for (String resourceName : resourceNames) {
            String className = this.toClassName(resourceName);
            Class<?> clazz = this.getClassLoader().loadClass(className);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                LOG.debug("Skipping abstract class: " + className);
                continue;
            }
            if (!implementedInterface.isAssignableFrom(clazz)) continue;
            try {
                ClassUtils.instantiate(className);
            }
            catch (Exception e) {
                throw new FlywayException("Unable to instantiate class: " + className);
            }
            classes.add(clazz);
            LOG.debug("Found class: " + className);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    private Set<String> findResourceNames(String path, String prefix, String suffix) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        List<URL> locationsUrls = this.getLocationUrlsForPath(path);
        for (URL locationUrl : locationsUrls) {
            LOG.debug("Scanning URL: " + locationUrl.toExternalForm());
            UrlResolver urlResolver = this.createUrlResolver(locationUrl.getProtocol());
            URL resolvedUrl = urlResolver.toStandardJavaUrl(locationUrl);
            String protocol = resolvedUrl.getProtocol();
            ClassPathLocationScanner classPathLocationScanner = this.createLocationScanner(protocol);
            if (classPathLocationScanner == null) {
                String scanRoot = UrlUtils.toFilePath(resolvedUrl);
                LOG.warn("Unable to scan location: " + scanRoot + " (unsupported protocol: " + protocol + ")");
                continue;
            }
            resourceNames.addAll(classPathLocationScanner.findResourceNames(path, resolvedUrl));
        }
        return this.filterResourceNames(resourceNames, prefix, suffix);
    }

    private List<URL> getLocationUrlsForPath(String path) throws IOException {
        ArrayList<URL> locationUrls = new ArrayList<URL>();
        if (this.getClassLoader().getClass().getName().startsWith("com.ibm")) {
            Enumeration<URL> urls = this.getClassLoader().getResources(path + "/flyway.location");
            if (!urls.hasMoreElements()) {
                throw new FlywayException("Unable to determine URL for classpath location: " + path + " (ClassLoader: " + this.getClassLoader() + ")" + " On WebSphere an empty file named flyway.location must be present on the classpath location for WebSphere to find it!");
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                locationUrls.add(new URL(URLDecoder.decode(url.toExternalForm(), "UTF-8").replace("/flyway.location", "")));
            }
        } else {
            Enumeration<URL> urls = this.getClassLoader().getResources(path);
            if (!urls.hasMoreElements()) {
                throw new FlywayException("Unable to determine URL for classpath location: " + path + " (ClassLoader: " + this.getClassLoader() + ")");
            }
            while (urls.hasMoreElements()) {
                locationUrls.add(urls.nextElement());
            }
        }
        return locationUrls;
    }

    private UrlResolver createUrlResolver(String protocol) {
        if (FeatureDetector.isJBossVFSv2Available() && protocol.startsWith("vfs")) {
            return new JBossVFSv2UrlResolver();
        }
        return new DefaultUrlResolver();
    }

    private ClassPathLocationScanner createLocationScanner(String protocol) {
        if ("file".equals(protocol)) {
            return new FileSystemClassPathLocationScanner();
        }
        if ("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) {
            return new JarFileClassPathLocationScanner();
        }
        if (FeatureDetector.isJBossVFSv3Available() && "vfs".equals(protocol)) {
            return new JBossVFSv3ClassPathLocationScanner();
        }
        if (FeatureDetector.isOsgiFrameworkAvailable() && ("bundle".equals(protocol) || "bundleresource".equals(protocol))) {
            return new OsgiClassPathLocationScanner();
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, String prefix, String suffix) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            String fileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
            if (fileName.startsWith(prefix) && fileName.endsWith(suffix) && fileName.length() > (prefix + suffix).length()) {
                filteredResourceNames.add(resourceName);
                continue;
            }
            LOG.debug("Filtering out resource: " + resourceName + " (filename: " + fileName + ")");
        }
        return filteredResourceNames;
    }
}

