/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Properties;
import java.util.function.BiConsumer;

public class PropertiesFileManager {
    private static final String CODEBASE_DIRECTORY = "config";
    public static final String OUTPUT_DIRECTORY = System.getenv("ACADEMIA_PROPERTIES");

    public static void main(String[] args) throws IOException {
        File outputDir = new File(OUTPUT_DIRECTORY);
        System.out.println("OUTPUT_DIRECTORY for properties file: " + OUTPUT_DIRECTORY);
        if (!outputDir.exists()) {
            throw new IOException("The OUTPUT_DIRECTORY environment variable for the properties file is not set yet. Please create a folder for it and set the folder's path as the value for the environment variable with the key ACADEMIA_PROPERTIES.");
        }
        PropertiesFileManager.copyPropertiesFiles(PropertiesFileManager.getSourceDirPath(CODEBASE_DIRECTORY), outputDir.toPath());
    }

    public static Path getSourceDirPath(String sourceDir) {
        Path sourceDirPath;
        block22: {
            sourceDirPath = null;
            ClassLoader classLoader = PropertiesFileManager.class.getClassLoader();
            try (InputStream inputStream = classLoader.getResourceAsStream(sourceDir);){
                if (inputStream == null) break block22;
                URI uri = null;
                try {
                    URL url = classLoader.getResource(sourceDir);
                    if (url != null) {
                        uri = url.toURI();
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                if (uri != null) {
                    if (uri.getScheme().equals("jar")) {
                        try {
                            FileSystem fileSystem = FileSystems.getFileSystem(uri);
                            sourceDirPath = fileSystem.getPath(File.separator + sourceDir, new String[0]);
                        }
                        catch (FileSystemNotFoundException e) {
                            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                            sourceDirPath = fileSystem.getPath(File.separator + sourceDir, new String[0]);
                        }
                    } else {
                        sourceDirPath = Paths.get(uri);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sourceDirPath;
    }

    private static void copyPropertiesFiles(Path sourceDir, Path targetDir) throws IOException {
        Files.walk(sourceDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".properties")).forEach(path -> {
            try {
                String fileName = path.getFileName().toString();
                Path targetFile = targetDir.resolve(fileName);
                PropertiesFileManager.copyPropertiesWithImmutability(path, targetFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static void copyPropertiesWithImmutability(Path sourceFile, Path targetFile) throws IOException {
        Throwable throwable;
        Properties sourceProperties = new Properties();
        try (InputStream inputStream = Files.newInputStream(sourceFile, new OpenOption[0]);){
            sourceProperties.load(inputStream);
        }
        Properties targetProperties = new Properties();
        if (Files.exists(targetFile, new LinkOption[0])) {
            throwable = null;
            try (InputStream inputStream = Files.newInputStream(targetFile, new OpenOption[0]);){
                targetProperties.load(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        sourceProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!targetProperties.containsKey(key)) {
                targetProperties.setProperty(key.toString(), value.toString());
            }
            if (key.toString().equals("appenders")) {
                targetProperties.replace(key.toString(), value.toString());
            }
            if (key.toString().equals("bypass-api-list")) {
                targetProperties.replace(key.toString(), value.toString());
            }
        }));
        throwable = null;
        try (OutputStream outputStream = Files.newOutputStream(targetFile, new OpenOption[0]);){
            targetProperties.store(outputStream, null);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }
}

