/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import in.serosoft.CriteriaBuilderConfigurer.PropertiesFileManager;
import in.serosoft.cb.model.SQLViewDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ViewDefinitionConfigurationApp {
    public static void main(String[] args) {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SearchConfiguratonService searchConfiguratonService = (SearchConfiguratonService)appContext.getBean("searchConfiguratonService");
        ViewDefinitionConfigurationApp.inserViewDefinitions(searchConfiguratonService);
        ((ConfigurableApplicationContext)appContext).close();
    }

    public static List<String> inserViewDefinitions(SearchConfiguratonService searchConfiguratonService) {
        ArrayList<String> nonExecutedXmls = new ArrayList<String>();
        try {
            String resourcePath = "XMLParser/viewDefinition";
            Path viewPath = PropertiesFileManager.getSourceDirPath(resourcePath);
            Files.walk(viewPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".xml")).forEach(file -> {
                block8: {
                    try {
                        InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                        if (inputStream != null) {
                            SQLViewDTO sqlViewDTO = ConfigurationReader.readSQLViewXmlFile(inputStream);
                            try {
                                searchConfiguratonService.configureSQLView(sqlViewDTO);
                                break block8;
                            }
                            catch (Exception e) {
                                nonExecutedXmls.add(file.getFileName().toString());
                                break block8;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        nonExecutedXmls.add(file.getFileName().toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nonExecutedXmls;
    }
}

