/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.SystemMenuConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import in.serosoft.sm.entity.SystemMenu;
import in.serosoft.sm.helper.SystemMenuDtoTOEntityConverter;
import in.serosoft.sm.model.SystemMenuDTO;
import in.serosoft.sm.model.SystemMenusListDTO;
import in.serosoft.sm.service.SystemMenuService;
import in.serosoft.sm.service.impl.LoginPageContentUtilityServiceImpl;
import in.serosoft.sm.xmlparser.SystemMenuDtoReader;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SystemMenuConfigurationApp {
    public static void main(String[] args) throws URISyntaxException {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SystemMenuService systemMenuService = (SystemMenuService)appContext.getBean("systemMenuService");
        InputStream inputStream = LoginPageContentUtilityServiceImpl.class.getClassLoader().getResourceAsStream("XMLParser/systemMenu/menu.xml");
        SystemMenusListDTO systemMenusListDTO = SystemMenuDtoReader.readXmlFile(inputStream);
        if (systemMenusListDTO != null) {
            System.out.println("Total size of menu: " + systemMenusListDTO.getMenu().size());
        } else {
            System.out.println("menu is null. Please check codebase");
            System.exit(1);
        }
        List<SystemMenuDTO> systemMenuList = systemMenusListDTO.getMenu();
        SystemMenuDtoTOEntityConverter systemMenuDtoTOEntityConverter = new SystemMenuDtoTOEntityConverter();
        for (SystemMenuDTO systemMenuDTO : systemMenuList) {
            SystemMenu systemMenu = systemMenuDtoTOEntityConverter.convertSystemMenuDtoToEntity(systemMenuDTO, systemMenuService);
            systemMenuService.create(systemMenu);
        }
        ((ConfigurableApplicationContext)appContext).close();
    }
}

