/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.MetadataFiller;

import in.serosoft.CriteriaBuilderConfigurer.DBProperties;
import in.serosoft.cb.MetadataFiller.EnumColumns;
import in.serosoft.cb.MetadataFiller.SearchTableColumnModel;
import in.serosoft.cb.MetadataFiller.SearchTableModel;
import in.serosoft.cb.MetadataFiller.SearchTableRelationModel;
import in.serosoft.cb.util.threadPool.ThreadJob;
import in.serosoft.cb.util.threadPool.ThreadPool;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class Dao {
    String url;
    String dbName;
    String driver;
    String userName;
    String password;
    String SCHEMA_NAME;
    Long timeDiffForDCA;
    static Map<String, String> tablePKMap = new HashMap<String, String>();
    static Map<String, String> dataTypeMap = new HashMap<String, String>();
    static Set<String> skipTablesSet = new HashSet<String>();
    static Map<String, String> enumTableColumnMap = EnumColumns.enumTableColumnMap;

    private void loadPKTable() {
        tablePKMap.put("students", "userId");
        tablePKMap.put("staffs", "userId");
    }

    public Dao(DBProperties dbProperties) throws IOException {
        this.url = dbProperties.getUrl();
        this.dbName = this.url.substring(this.url.lastIndexOf(47) + 1, this.url.lastIndexOf(63));
        this.driver = dbProperties.getDriver();
        this.userName = dbProperties.getUserName();
        this.password = dbProperties.getPassword();
        this.SCHEMA_NAME = "${" + this.dbName + "}";
        this.timeDiffForDCA = 2L;
    }

    private List<SearchTableModel> findSearchTableModels(Connection conn, Set<Integer> searchTableSelectedIds) throws Exception {
        ArrayList<String> tableList = new ArrayList<String>(2000);
        ArrayList<SearchTableModel> searchTableModels = new ArrayList<SearchTableModel>();
        String query = "call sp_search_table_master(?,?)";
        CallableStatement cb = conn.prepareCall(query);
        cb.setString(1, this.dbName);
        cb.setLong(2, (long)this.timeDiffForDCA);
        ResultSet result = cb.executeQuery();
        while (result.next() && !tableList.contains(result.getString(2))) {
            tableList.add(result.getString(2));
            String tableName = result.getString(2);
            if (skipTablesSet.contains(tableName.toLowerCase())) continue;
            SearchTableModel searchTableModel = new SearchTableModel();
            searchTableModel.setDbTableName(tableName);
            searchTableModel.setI18nDisplayCode("cb." + tableName);
            if (result.getInt(1) == 0) {
                searchTableModel.setId(null);
            } else {
                searchTableModel.setId(result.getInt(1));
                searchTableSelectedIds.add(result.getInt(1));
            }
            searchTableModels.add(searchTableModel);
        }
        result.close();
        cb.close();
        return searchTableModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> buildSearchTableIdMap(Connection conn) throws SQLException {
        Statement st2 = null;
        ResultSet rr = null;
        HashMap<String, Integer> searchTableMap = new HashMap<String, Integer>();
        try {
            st2 = conn.createStatement();
            String sql3 = "select id,dbTableName from search_table";
            rr = st2.executeQuery(sql3);
            while (rr.next()) {
                searchTableMap.put(rr.getString(2), rr.getInt(1));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            st2.close();
            rr.close();
        }
        return searchTableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> buildSearchTableRelationIdSet(Connection conn, Set<Integer> collection) throws SQLException {
        if (collection == null || collection.isEmpty()) {
            return new HashSet<String>();
        }
        Statement statement = null;
        ResultSet resultSet = null;
        HashSet<String> searchTableRelationSet = null;
        StringBuilder stringBuilder = new StringBuilder();
        int count = 1;
        for (Integer id : collection) {
            if (count == 1) {
                stringBuilder.append("select fromTableId,toTableId,joinClause from search_table_relation where fromTableId in (");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(id);
            ++count;
        }
        stringBuilder.append(");");
        try {
            statement = conn.createStatement();
            resultSet = statement.executeQuery(stringBuilder.toString());
            searchTableRelationSet = new HashSet<String>();
            while (resultSet.next()) {
                searchTableRelationSet.add(resultSet.getLong(1) + "-" + resultSet.getLong(2) + "-" + resultSet.getString(3));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            statement.close();
            resultSet.close();
        }
        return searchTableRelationSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> buildSearchTableColumnIdSet(Connection conn, Collection<Integer> collection) throws SQLException {
        if (collection == null || collection.isEmpty()) {
            return new HashSet<String>();
        }
        Statement statement = null;
        ResultSet resultSet = null;
        HashSet<String> searchTableColumnSet = null;
        StringBuilder stringBuilder = new StringBuilder();
        int count = 1;
        for (Integer id : collection) {
            if (count == 1) {
                stringBuilder.append("select searchTableId, columnName, criteriaPrivilegeLevel, displayCode, dataType, ");
                stringBuilder.append("virtualField, enumType, whetherOccupied from search_table_column where searchTableId in(");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(id);
            ++count;
        }
        stringBuilder.append(");");
        try {
            statement = conn.createStatement();
            resultSet = statement.executeQuery(stringBuilder.toString());
            searchTableColumnSet = new HashSet<String>();
            while (resultSet.next()) {
                searchTableColumnSet.add(resultSet.getLong(1) + "-" + resultSet.getString(2) + "-" + resultSet.getString(3) + "-" + resultSet.getString(4) + "-" + resultSet.getString(5) + "-" + resultSet.getString(6) + "-" + resultSet.getString(7) + "-" + resultSet.getBoolean(8));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            statement.close();
            resultSet.close();
        }
        return searchTableColumnSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateFeaturePrivilege() {
        System.out.println("Feature tables truncate start.");
        Statement statement = null;
        try {
            Class.forName(this.driver).newInstance();
            Connection conn = DriverManager.getConnection(this.url, this.userName, this.password);
            statement = conn.createStatement();
            String query1 = "SET FOREIGN_KEY_CHECKS=0;";
            String query2 = "TRUNCATE TABLE `system_menu`;";
            String query3 = "TRUNCATE TABLE `feature_privilege`;";
            String query4 = "TRUNCATE TABLE `feature`;";
            String query5 = "TRUNCATE TABLE `system_modules`;";
            String query6 = "SET FOREIGN_KEY_CHECKS=1;";
            conn.setAutoCommit(false);
            statement.addBatch(query1);
            statement.addBatch(query2);
            statement.addBatch(query3);
            statement.addBatch(query4);
            statement.addBatch(query5);
            statement.addBatch(query6);
            statement.executeBatch();
            conn.commit();
            System.out.println("Feature tables truncate done.");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateTableDetails() throws Exception {
        try {
            this.loadPKTable();
            Class.forName(this.driver).newInstance();
            final Connection conn = DriverManager.getConnection(this.url, this.userName, this.password);
            System.out.println("searchTable model START- " + new Date());
            HashSet<Integer> searchTableSelectedIds = new HashSet<Integer>();
            List<Object> searchTableModels = new ArrayList();
            searchTableModels = this.findSearchTableModels(conn, searchTableSelectedIds);
            final Map<String, Integer> searchTableMap = this.buildSearchTableIdMap(conn);
            System.out.println("searchTable model END- " + new Date());
            final Set<String> searchTableRelationSet = this.buildSearchTableRelationIdSet(conn, searchTableSelectedIds);
            System.out.println("searchTable relation model START- " + new Date());
            final CopyOnWriteArrayList<SearchTableRelationModel> searchTableRelations = new CopyOnWriteArrayList<SearchTableRelationModel>();
            final Set<String> searchTableColumnSet = this.buildSearchTableColumnIdSet(conn, searchTableSelectedIds);
            searchTableSelectedIds = null;
            final CopyOnWriteArrayList<SearchTableColumnModel> searchTableColumnModels = new CopyOnWriteArrayList<SearchTableColumnModel>();
            ExecutorService executor = ThreadPool.getExecutor();
            int counter = searchTableModels.size();
            System.out.println("Total updated table count is: " + counter);
            for (final SearchTableModel searchTableModel : searchTableModels) {
                ThreadJob newJob = new ThreadJob(counter--){

                    @Override
                    public void run() {
                        try {
                            HashSet foriegnKeySet = new HashSet();
                            Dao.this.buildSearchTableRelationModel(conn, searchTableMap, searchTableRelationSet, searchTableRelations, foriegnKeySet, searchTableModel);
                            Dao.this.buildSearchTableColumnModel(foriegnKeySet, searchTableColumnSet, searchTableColumnModels, searchTableModel, conn);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                executor.execute(newJob);
            }
            try {
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            searchTableModels.clear();
            searchTableMap.clear();
            System.out.println("searchTable relation model END- " + new Date());
            System.out.println("searchTable relation Insert START- " + new Date());
            if (searchTableRelations != null && !searchTableRelations.isEmpty()) {
                this.insertStatmentOfSearchTableRelation(conn, searchTableRelations);
            }
            System.out.println("searchTable relation Insert END- " + new Date());
            System.out.println("searchTable column Insert START- " + new Date());
            if (searchTableColumnModels != null && !searchTableColumnModels.isEmpty()) {
                this.insertSearchTableColumn(conn, searchTableColumnModels);
            }
            System.out.println("searchTable column Insert END- " + new Date());
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSearchTableColumn(Connection conn, List<SearchTableColumnModel> searchTableColumnModels) throws SQLException {
        StringBuilder sql1 = new StringBuilder();
        int count = 1;
        Statement st1 = conn.createStatement();
        for (SearchTableColumnModel searchtableColumnModel : searchTableColumnModels) {
            if (searchTableColumnModels.size() > 1) {
                if (count == 1) {
                    sql1.append("insert into search_table_column(columnName,criteriaPrivilegeLevel,dataType,displayCode,virtualField,");
                    sql1.append("searchTableId,enumType,whetherOccupied) values('");
                    sql1.append(searchtableColumnModel.getColumnName());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getCriterisPrivilegeLevel());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getDataType());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getDisplayCode());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getVirtualField());
                    sql1.append("',");
                    sql1.append(searchtableColumnModel.searchTableId);
                    sql1.append(",");
                    sql1.append(searchtableColumnModel.enumType);
                    sql1.append(",");
                    sql1.append(searchtableColumnModel.whetherOccupied);
                    sql1.append("),");
                } else if (count == searchTableColumnModels.size()) {
                    sql1.append("('");
                    sql1.append(searchtableColumnModel.getColumnName());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getCriterisPrivilegeLevel());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getDataType());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getDisplayCode());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getVirtualField());
                    sql1.append("',");
                    sql1.append(searchtableColumnModel.searchTableId);
                    sql1.append(",");
                    sql1.append(searchtableColumnModel.enumType);
                    sql1.append(",");
                    sql1.append(searchtableColumnModel.whetherOccupied);
                    sql1.append(");");
                } else {
                    sql1.append("('");
                    sql1.append(searchtableColumnModel.getColumnName());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getCriterisPrivilegeLevel());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getDataType());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getDisplayCode());
                    sql1.append("','");
                    sql1.append(searchtableColumnModel.getVirtualField());
                    sql1.append("',");
                    sql1.append(searchtableColumnModel.searchTableId);
                    sql1.append(",");
                    sql1.append(searchtableColumnModel.enumType);
                    sql1.append(",");
                    sql1.append(searchtableColumnModel.whetherOccupied + "),");
                }
                ++count;
                continue;
            }
            sql1.append("insert into search_table_column(columnName,criteriaPrivilegeLevel,dataType,displayCode,virtualField,");
            sql1.append("searchTableId,enumType,whetherOccupied) values('");
            sql1.append(searchtableColumnModel.getColumnName());
            sql1.append("','");
            sql1.append(searchtableColumnModel.getCriterisPrivilegeLevel());
            sql1.append("','");
            sql1.append(searchtableColumnModel.getDataType());
            sql1.append("','");
            sql1.append(searchtableColumnModel.getDisplayCode());
            sql1.append("','");
            sql1.append(searchtableColumnModel.getVirtualField());
            sql1.append("',");
            sql1.append(searchtableColumnModel.searchTableId);
            sql1.append(",");
            sql1.append(searchtableColumnModel.enumType);
            sql1.append(",");
            sql1.append(searchtableColumnModel.whetherOccupied);
            sql1.append(");");
        }
        try {
            st1.executeUpdate(sql1.toString());
        }
        catch (Exception e) {
            System.out.println("Error in: " + sql1.toString());
            e.printStackTrace();
        }
        finally {
            st1.close();
            sql1 = null;
            searchTableColumnModels = null;
        }
    }

    private void buildSearchTableColumnModel(Set<String> refColumns, Set<String> searchTableColumnSet, List<SearchTableColumnModel> searchTableColumnModels, SearchTableModel stRecord, Connection conn) {
        try {
            PreparedStatement preparedStatement = conn.prepareStatement("SELECT COLUMN_NAME, DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ? and TABLE_NAME=?;");
            preparedStatement.setString(1, this.dbName);
            preparedStatement.setString(2, stRecord.getDbTableName());
            ResultSet columns = preparedStatement.executeQuery();
            while (columns.next()) {
                String sqlDataType = columns.getString(2);
                String columnName = columns.getString(1);
                String dataType = null;
                if (columnName.equalsIgnoreCase(tablePKMap.get(stRecord.getDbTableName()))) {
                    dataType = "IDENTITY";
                } else if (refColumns != null && refColumns.contains(columnName)) {
                    if (refColumns.contains(columnName)) {
                        dataType = "REF_IDENTITY";
                    }
                } else if ("id".equalsIgnoreCase(columnName)) {
                    dataType = "IDENTITY";
                } else {
                    if ("version".equalsIgnoreCase(columnName)) continue;
                    dataType = dataTypeMap.get(sqlDataType.toLowerCase());
                }
                String enumType = enumTableColumnMap.get(stRecord.getDbTableName() + "#" + columnName);
                if (enumType != null) {
                    dataType = "ENUM";
                    enumType = "'" + enumType + "'";
                }
                Boolean whetherOccupied = true;
                if (stRecord.getDbTableName().endsWith("_cd")) {
                    whetherOccupied = false;
                }
                if (searchTableColumnSet.contains(stRecord.getId() + "-" + columnName + "-1-cb." + stRecord.getDbTableName() + "." + columnName + "-" + dataType + "-0-" + enumType + "-" + whetherOccupied)) continue;
                SearchTableColumnModel searchTableColumnModel = new SearchTableColumnModel();
                searchTableColumnModel.setColumnName(columnName);
                searchTableColumnModel.setSearchTableId(stRecord.getId());
                searchTableColumnModel.setCriterisPrivilegeLevel("1");
                searchTableColumnModel.setDisplayCode("cb." + stRecord.getDbTableName() + "." + columnName);
                searchTableColumnModel.setDataType(dataType);
                searchTableColumnModel.setVirtualField("0");
                searchTableColumnModel.setEnumType(enumType);
                searchTableColumnModel.setWhetherOccupied(whetherOccupied);
                searchTableColumnModels.add(searchTableColumnModel);
            }
            columns.close();
            preparedStatement.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertStatmentOfSearchTableRelation(Connection conn, List<SearchTableRelationModel> searchTableRelations) throws SQLException {
        Statement statement = conn.createStatement();
        StringBuilder sql = new StringBuilder();
        int count = 1;
        for (SearchTableRelationModel searchTableRelation : searchTableRelations) {
            if (searchTableRelations.size() > 1) {
                if (count == 1) {
                    sql.append("insert into search_table_relation(joinClause,fromTableId,toTableId) values('");
                    sql.append(searchTableRelation.getJoinCondition());
                    sql.append("',");
                    sql.append(searchTableRelation.getFromTableId());
                    sql.append(",");
                    sql.append(searchTableRelation.getToTableId());
                    sql.append("),");
                } else if (count == searchTableRelations.size()) {
                    sql.append("('");
                    sql.append(searchTableRelation.getJoinCondition());
                    sql.append("',");
                    sql.append(searchTableRelation.getFromTableId());
                    sql.append(",");
                    sql.append(searchTableRelation.getToTableId());
                    sql.append(");");
                } else {
                    sql.append("('");
                    sql.append(searchTableRelation.getJoinCondition());
                    sql.append("',");
                    sql.append(searchTableRelation.getFromTableId());
                    sql.append(",");
                    sql.append(searchTableRelation.getToTableId());
                    sql.append("),");
                }
                ++count;
                continue;
            }
            sql.append("insert into search_table_relation(joinClause,fromTableId,toTableId) values('");
            sql.append(searchTableRelation.getJoinCondition());
            sql.append("',");
            sql.append(searchTableRelation.getFromTableId());
            sql.append(",");
            sql.append(searchTableRelation.getToTableId());
            sql.append(");");
        }
        try {
            statement.executeUpdate(sql.toString());
        }
        catch (Exception e) {
            System.out.println("Error in: " + sql.toString());
            e.printStackTrace();
        }
        finally {
            statement.close();
            searchTableRelations = null;
        }
    }

    private void buildSearchTableRelationModel(Connection conn, Map<String, Integer> searchTableMap, Set<String> searchTableRelationSet, List<SearchTableRelationModel> searchTableRelations, Set<String> toTableRefColumns, SearchTableModel stRecord) throws SQLException {
        int toTableId = searchTableMap.get(stRecord.getDbTableName());
        PreparedStatement preparedStatement = conn.prepareStatement("SELECT REFERENCED_TABLE_NAME, COLUMN_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE REFERENCED_TABLE_SCHEMA  = ? AND TABLE_NAME  = ?;");
        preparedStatement.setString(1, this.dbName);
        preparedStatement.setString(2, stRecord.getDbTableName());
        ResultSet resu1 = preparedStatement.executeQuery();
        while (resu1.next()) {
            String fromTableName = resu1.getString(1);
            String toTableColumnName = resu1.getString(2);
            boolean isUpperCase = false;
            boolean isLowerCase = false;
            if (!searchTableMap.containsKey(fromTableName)) {
                if (searchTableMap.containsKey(fromTableName.toUpperCase())) {
                    isUpperCase = true;
                } else if (searchTableMap.containsKey(fromTableName.toLowerCase())) {
                    isLowerCase = true;
                } else {
                    System.out.println("Null record in search table fromTableName: " + fromTableName + ", toTableColumnName: " + toTableColumnName);
                }
            }
            Integer fromTableId = isUpperCase ? searchTableMap.get(fromTableName.toUpperCase()) : (isLowerCase ? searchTableMap.get(fromTableName.toLowerCase()) : searchTableMap.get(fromTableName));
            toTableRefColumns.add(toTableColumnName);
            String joinCondition = "FROMTABLE.id = TOTABLE." + toTableColumnName;
            if (fromTableId == null || searchTableRelationSet.contains(fromTableId + "-" + toTableId + "-" + joinCondition)) continue;
            SearchTableRelationModel searchTableRelationModel = new SearchTableRelationModel();
            searchTableRelationModel.setFromTableId(fromTableId);
            searchTableRelationModel.setToTableId(toTableId);
            searchTableRelationModel.setJoinCondition(joinCondition);
            searchTableRelations.add(searchTableRelationModel);
        }
        resu1.close();
        preparedStatement.close();
    }

    static {
        dataTypeMap.put("varchar", "STRING");
        dataTypeMap.put("bigint", "NUMBER");
        dataTypeMap.put("int", "NUMBER");
        dataTypeMap.put("tinyint", "NUMBER");
        dataTypeMap.put("smallint", "NUMBER");
        dataTypeMap.put("char", "STRING");
        dataTypeMap.put("float", "NUMBER");
        dataTypeMap.put("double", "NUMBER");
        dataTypeMap.put("decimal", "NUMBER");
        dataTypeMap.put("timestamp", "DATE");
        dataTypeMap.put("date", "DATE");
        dataTypeMap.put("datetime", "DATE");
        dataTypeMap.put("time", "DATE");
        dataTypeMap.put("longtext", "STRING");
        dataTypeMap.put("text", "STRING");
        dataTypeMap.put("bit", "BOOLEAN");
        dataTypeMap.put("blob", "BLOB");
        dataTypeMap.put("varbinary", "STRING");
        dataTypeMap.put("set", "STRING");
        dataTypeMap.put("mediumtext", "STRING");
        dataTypeMap.put("mediumblob", "BLOB");
        dataTypeMap.put("longblob", "BLOB");
        dataTypeMap.put("json", "STRING");
        dataTypeMap.put("enum", "STRING");
        dataTypeMap.put("binary", "STRING");
        skipTablesSet.add("basic_search_config");
        skipTablesSet.add("basic_search_config_param");
        skipTablesSet.add("default_search_criterias");
        skipTablesSet.add("saved_search");
        skipTablesSet.add("saved_search_criteria");
        skipTablesSet.add("saved_search_sort_criteria");
        skipTablesSet.add("search_aggregation_column");
        skipTablesSet.add("search_config");
        skipTablesSet.add("search_config_table");
        skipTablesSet.add("search_implicit_criteria");
        skipTablesSet.add("search_result_enhancer");
        skipTablesSet.add("search_result_view");
        skipTablesSet.add("search_result_view_column");
        skipTablesSet.add("search_result_view_sort");
        skipTablesSet.add("search_sql_group");
        skipTablesSet.add("search_sql_groupby");
        skipTablesSet.add("search_result_formatter_params");
        skipTablesSet.add("search_table");
        skipTablesSet.add("search_table_column");
        skipTablesSet.add("search_table_relation");
        skipTablesSet.add("search_criteria_operator");
    }
}

